/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.runtime.ThreadContext;

public class UnboxedBoolean
extends ImmutableLiteral {
    private final boolean truthy;
    public static final UnboxedBoolean TRUE = new UnboxedBoolean(true);
    public static final UnboxedBoolean FALSE = new UnboxedBoolean(false);

    public UnboxedBoolean(boolean truthy) {
        super(OperandType.UNBOXED_BOOLEAN);
        this.truthy = truthy;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return context.runtime.newBoolean(this.isTrue());
    }

    public boolean isTrue() {
        return this.truthy;
    }

    public boolean isFalse() {
        return !this.truthy;
    }

    public boolean equals(Object other) {
        return other instanceof UnboxedBoolean && this.truthy == ((UnboxedBoolean)other).truthy;
    }

    public int hashCode() {
        return 287 + (this.truthy ? 1 : 0);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.UnboxedBoolean(this);
    }

    public String toString() {
        return this.isTrue() ? "true" : "false";
    }
}

