/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class StringLiteral
extends Operand {
    public static final StringLiteral EMPTY_STRING = new StringLiteral("");
    public final ByteList bytelist;
    public final String string;
    public final int coderange;

    public StringLiteral(ByteList val) {
        this(val, 16);
    }

    public StringLiteral(ByteList val, int coderange) {
        super(OperandType.STRING_LITERAL);
        String stringTemp;
        this.bytelist = val;
        this.coderange = coderange;
        try {
            stringTemp = Helpers.byteListToString(this.bytelist);
        }
        catch (UnsupportedCharsetException e) {
            stringTemp = this.bytelist.toString();
        }
        this.string = stringTemp;
    }

    public StringLiteral(String s2) {
        this(s2, ByteList.create(s2));
    }

    private StringLiteral(String string2, ByteList byteList) {
        super(OperandType.STRING_LITERAL);
        this.bytelist = byteList;
        this.string = string2;
        this.coderange = 16;
    }

    @Override
    public boolean hasKnownValue() {
        return true;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    public int hashCode() {
        return this.bytelist.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof StringLiteral && this.bytelist.equals(((StringLiteral)other).bytelist);
    }

    public String toString() {
        return "\"" + this.string + "\"";
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return RubyString.newStringShared(context.runtime, this.bytelist);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.StringLiteral(this);
    }

    public ByteList getByteList() {
        return this.bytelist;
    }

    public String getString() {
        return this.string;
    }

    public int getCodeRange() {
        return this.coderange;
    }
}

