/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class UnresolvedSuperInstr
extends CallInstr {
    public static final String UNKNOWN_SUPER_TARGET = "-unknown-super-target-";

    public UnresolvedSuperInstr(Operation op, Variable result2, Operand receiver2, Operand[] args2, Operand closure) {
        super(op, CallType.SUPER, result2, UNKNOWN_SUPER_TARGET, receiver2, args2, closure);
    }

    public UnresolvedSuperInstr(Variable result2, Operand receiver2, Operand[] args2, Operand closure) {
        this(Operation.UNRESOLVED_SUPER, result2, receiver2, args2, closure);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.REQUIRES_FRAME);
        scope.getFlags().add(IRFlags.REQUIRES_DYNSCOPE);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new UnresolvedSuperInstr(ii.getRenamedVariable(this.getResult()), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.getClosureArg() == null ? null : this.getClosureArg().cloneForInlining(ii));
    }

    @Override
    public Instr discardResult() {
        return this;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject[] args2 = this.prepareArguments(context, self2, currScope, currDynScope, temp);
        Block block = this.prepareBlock(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.unresolvedSuper(context, self2, args2, block);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.UnresolvedSuperInstr(this);
    }
}

