/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.MultipleAsgnBase;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class OptArgMultipleAsgnInstr
extends MultipleAsgnBase
implements FixedArityInstr {
    private final int minArgsLength;

    public OptArgMultipleAsgnInstr(Variable result2, Operand array, int index2, int minArgsLength) {
        super(Operation.MASGN_OPT, result2, array, index2);
        this.minArgsLength = minArgsLength;
    }

    public int getMinArgsLength() {
        return this.minArgsLength;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getArray() + "," + this.index + "," + this.minArgsLength + ")";
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new OptArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), this.getArray().cloneForInlining(ii), this.index, this.minArgsLength);
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyArray rubyArray = (RubyArray)this.getArray().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.extractOptionalArgument(rubyArray, this.minArgsLength, this.index);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.OptArgMultipleAsgnInstr(this);
    }
}

