/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class NonlocalReturnInstr
extends ReturnBase
implements FixedArityInstr {
    public final String methodName;

    public NonlocalReturnInstr(Operand returnValue, String methodName) {
        super(Operation.NONLOCAL_RETURN, returnValue);
        this.methodName = methodName;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.getReturnValue(), new StringLiteral(this.methodName)};
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getOperation()) + "(" + this.getReturnValue() + ", <" + this.methodName + ">" + ")";
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.HAS_NONLOCAL_RETURNS);
        return true;
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new NonlocalReturnInstr(this.getReturnValue().cloneForInlining(info), this.methodName);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.isClosure()) {
            if (ii.getHostScope() instanceof IRMethod) {
                Variable v = ii.getCallResultVariable();
                return v == null ? null : new CopyInstr(v, this.getReturnValue().cloneForInlining(ii));
            }
            return new NonlocalReturnInstr(this.getReturnValue().cloneForInlining(ii), this.methodName);
        }
        throw new UnsupportedOperationException("Nonlocal returns shouldn't show up outside closures.");
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.NonlocalReturnInstr(this);
    }
}

