/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyRegexp;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Match3Instr
extends ResultBaseInstr
implements FixedArityInstr {
    public Match3Instr(Variable result2, Operand receiver2, Operand arg2) {
        super(Operation.MATCH3, result2, new Operand[]{receiver2, arg2});
        assert (result2 != null) : "Match3Instr result is null";
    }

    public Operand getArg() {
        return this.operands[1];
    }

    public Operand getReceiver() {
        return this.operands[0];
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.USES_BACKREF_OR_LASTLINE);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new Match3Instr((Variable)this.result.cloneForInlining(ii), this.getReceiver().cloneForInlining(ii), this.getArg().cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyRegexp regexp2 = (RubyRegexp)this.getReceiver().retrieve(context, self2, currScope, currDynScope, temp);
        IRubyObject argValue = (IRubyObject)this.getArg().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.match3(context, regexp2, argValue);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Match3Instr(this);
    }
}

