/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.InlinedLineNumberInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;

public class LineNumberInstr
extends Instr
implements FixedArityInstr {
    public final int lineNumber;

    public LineNumberInstr(int lineNumber) {
        super(Operation.LINE_NUM, EMPTY_OPERANDS);
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.lineNumber + ")";
    }

    @Override
    public Instr clone(CloneInfo ii) {
        if (ii instanceof InlineCloneInfo) {
            new InlinedLineNumberInstr(((InlineCloneInfo)ii).getScopeBeingInlined(), this.lineNumber);
        }
        return this;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LineNumberInstr(this);
    }
}

