/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;

public class InheritanceSearchConstInstr
extends ResultBaseInstr
implements FixedArityInstr {
    String constName;
    private final boolean noPrivateConsts;
    private volatile transient ConstantCache cache;

    public InheritanceSearchConstInstr(Variable result2, Operand currentModule, String constName, boolean noPrivateConsts) {
        super(Operation.INHERITANCE_SEARCH_CONST, result2, new Operand[]{currentModule});
        assert (result2 != null) : "InheritanceSearchConstInstr result is null";
        this.constName = constName;
        this.noPrivateConsts = noPrivateConsts;
    }

    public Operand getCurrentModule() {
        return this.operands[0];
    }

    public String getConstName() {
        return this.constName;
    }

    public boolean isNoPrivateConsts() {
        return this.noPrivateConsts;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new InheritanceSearchConstInstr(ii.getRenamedVariable(this.result), this.getCurrentModule().cloneForInlining(ii), this.constName, this.noPrivateConsts);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getCurrentModule() + ", " + this.constName + ")";
    }

    private Object cache(Ruby runtime, RubyModule module) {
        IRubyObject constant;
        IRubyObject iRubyObject = constant = this.noPrivateConsts ? module.getConstantFromNoConstMissing(this.constName, false) : module.getConstantNoConstMissing(this.constName);
        if (constant == null) {
            constant = UndefinedValue.UNDEFINED;
        } else {
            Invalidator invalidator = runtime.getConstantInvalidator(this.constName);
            this.cache = new ConstantCache(constant, invalidator.getData(), invalidator, module.hashCode());
        }
        return constant;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object cmVal = this.getCurrentModule().retrieve(context, self2, currScope, currDynScope, temp);
        if (!(cmVal instanceof RubyModule)) {
            throw context.runtime.newTypeError(cmVal + " is not a type/class");
        }
        RubyModule module = (RubyModule)cmVal;
        ConstantCache cache = this.cache;
        return !ConstantCache.isCachedFrom(module, cache) ? this.cache(context.runtime, module) : cache.value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.InheritanceSearchConstInstr(this);
    }
}

