/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.Ruby;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class DefineMetaClassInstr
extends ResultBaseInstr
implements FixedArityInstr {
    private final IRModuleBody metaClassBody;

    public DefineMetaClassInstr(Variable result2, Operand object, IRModuleBody metaClassBody) {
        super(Operation.DEF_META_CLASS, result2, new Operand[]{object});
        assert (result2 != null) : "DefineMetaClassInstr result is null";
        this.metaClassBody = metaClassBody;
    }

    public IRModuleBody getMetaClassBody() {
        return this.metaClassBody;
    }

    public Operand getObject() {
        return this.operands[0];
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.metaClassBody.getName() + ", " + this.getObject() + ", " + this.metaClassBody.getFileName() + ")";
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new DefineMetaClassInstr(ii.getRenamedVariable(this.result), this.getObject().cloneForInlining(ii), this.metaClassBody);
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Ruby runtime = context.runtime;
        IRubyObject obj = (IRubyObject)this.getObject().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.newInterpretedMetaClass(runtime, this.metaClassBody, obj);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineMetaClassInstr(this);
    }
}

