/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyArray;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CheckArgsArrayArityInstr
extends Instr
implements FixedArityInstr {
    public final int required;
    public final int opt;
    public final int rest;

    public CheckArgsArrayArityInstr(Operand argsArray, int required, int opt, int rest2) {
        super(Operation.CHECK_ARGS_ARRAY_ARITY, new Operand[]{argsArray});
        this.required = required;
        this.opt = opt;
        this.rest = rest2;
    }

    public Operand getArgsArray() {
        return this.operands[0];
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getOperation()) + "(" + this.getArgsArray() + ", " + this.required + ", " + this.opt + ", " + this.rest + ")";
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new CheckArgsArrayArityInstr(this.getArgsArray().cloneForInlining(ii), this.required, this.opt, this.rest);
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        RubyArray args2 = (RubyArray)this.getArgsArray().retrieve(context, self2, currScope, currDynScope, temp);
        Helpers.irCheckArgsArrayArity(context, args2, this.required, this.opt, this.rest);
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CheckArgsArrayArityInstr(this);
    }
}

