/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jruby.dirgra.Edge;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.FlowGraphNode;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;

public class LiveVariableNode
extends FlowGraphNode<LiveVariablesProblem, LiveVariableNode> {
    private BitSet in;
    private BitSet out;
    private BitSet living;
    private int setSize;

    public LiveVariableNode(LiveVariablesProblem prob, BasicBlock n) {
        super(prob, n);
    }

    @Override
    public void init() {
        this.setSize = ((LiveVariablesProblem)this.problem).getDFVarsCount();
        this.out = new BitSet(this.setSize);
    }

    private void addDFVar(Variable v) {
        if (!((LiveVariablesProblem)this.problem).dfVarExists(v)) {
            ((LiveVariablesProblem)this.problem).addDFVar(v);
        }
    }

    @Override
    public void buildDataFlowVars(Instr i2) {
        if (i2 instanceof ResultInstr) {
            this.addDFVar(((ResultInstr)((Object)i2)).getResult());
        }
        for (Variable x : i2.getUsedVariables()) {
            this.addDFVar(x);
        }
    }

    @Override
    public void applyPreMeetHandler() {
        Collection<LocalVariable> lv;
        this.in = new BitSet(this.setSize);
        if (this.basicBlock.isExitBB() && (lv = ((LiveVariablesProblem)this.problem).getVarsLiveOnScopeExit()) != null && !lv.isEmpty()) {
            for (Variable variable : lv) {
                this.in.set(((LiveVariablesProblem)this.problem).getDFVar(variable));
            }
        }
    }

    @Override
    public void compute_MEET(Edge e, LiveVariableNode pred2) {
        this.in.or(pred2.out);
    }

    private void markAllVariablesLive(LiveVariablesProblem lvp, BitSet living, Collection<? extends Variable> variableList) {
        for (Variable variable : variableList) {
            this.markVariableLive(lvp, living, variable);
        }
    }

    private void markVariableLive(LiveVariablesProblem lvp, BitSet living, Variable x) {
        Integer dv = lvp.getDFVar(x);
        if (dv != null) {
            living.set(dv);
        }
    }

    @Override
    public void initSolution() {
        this.living = (BitSet)this.in.clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTransferFunction(Instr i2) {
        boolean scopeBindingHasEscaped = ((LiveVariablesProblem)this.problem).getScope().bindingHasEscaped();
        if (i2 instanceof ResultInstr) {
            Variable v = ((ResultInstr)((Object)i2)).getResult();
            this.living.clear(((LiveVariablesProblem)this.problem).getDFVar(v));
        }
        if (i2 instanceof ClosureAcceptingInstr) {
            Operand o = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg();
            if (o != null && o instanceof WrappedIRClosure) {
                List<Variable> list2;
                boolean changed;
                void var5_7;
                IRClosure cl = ((WrappedIRClosure)o).getClosure();
                LiveVariablesProblem liveVariablesProblem = (LiveVariablesProblem)cl.getDataFlowSolution("Live Variables Analysis");
                boolean needsInit = false;
                if (liveVariablesProblem == null) {
                    LiveVariablesProblem liveVariablesProblem2 = new LiveVariablesProblem(cl, ((LiveVariablesProblem)this.problem).getNonSelfLocalVars());
                    cl.setDataFlowSolution(liveVariablesProblem2.getName(), liveVariablesProblem2);
                    cl.computeScopeFlags();
                    needsInit = true;
                }
                Set<LocalVariable> liveVars = ((LiveVariablesProblem)this.problem).addLiveLocalVars(new HashSet<LocalVariable>(), this.living);
                List<Variable> liveOnEntryBefore = var5_7.getVarsLiveOnScopeEntry();
                for (Variable variable : liveOnEntryBefore) {
                    if (!(variable instanceof LocalVariable)) continue;
                    liveVars.add((LocalVariable)variable);
                }
                if (i2.canRaiseException()) {
                    ((LiveVariablesProblem)this.problem).addLiveLocalVars(liveVars, ((LiveVariableNode)this.getExceptionTargetNode()).out);
                }
                var5_7.setVarsLiveOnScopeExit(liveVars);
                if (needsInit) {
                    for (Variable variable : liveVars) {
                        var5_7.addDFVar(variable);
                    }
                }
                var5_7.compute_MOP_Solution();
                do {
                    changed = false;
                    list2 = var5_7.getVarsLiveOnScopeEntry();
                    for (Variable y : list2) {
                        LocalVariable ly;
                        if (!(y instanceof LocalVariable) || liveVars.contains(ly = (LocalVariable)y)) continue;
                        changed = true;
                        liveVars.add(ly);
                    }
                    if (!changed) continue;
                    var5_7.setVarsLiveOnScopeExit(liveVars);
                    var5_7.compute_MOP_Solution();
                } while (changed);
                this.markAllVariablesLive((LiveVariablesProblem)this.problem, this.living, list2);
            }
            if (scopeBindingHasEscaped) {
                for (Variable variable : ((LiveVariablesProblem)this.problem).getNonSelfLocalVars()) {
                    this.living.set(((LiveVariablesProblem)this.problem).getDFVar(variable));
                }
            }
        }
        if (i2.canRaiseException()) {
            this.makeOutExceptionVariablesLiving(this.living);
        }
        this.markAllVariablesLive((LiveVariablesProblem)this.problem, this.living, i2.getUsedVariables());
    }

    @Override
    public boolean solutionChanged() {
        return !this.living.equals(this.out);
    }

    @Override
    public void finalizeSolution() {
        this.out = this.living;
    }

    private void makeOutExceptionVariablesLiving(BitSet living) {
        BitSet etOut = ((LiveVariableNode)this.getExceptionTargetNode()).out;
        for (int i2 = 0; i2 < etOut.size(); ++i2) {
            if (!etOut.get(i2)) continue;
            living.set(i2);
        }
    }

    public String toString() {
        int i2;
        StringBuilder buf = new StringBuilder();
        buf.append("\tVars Live on Entry: ");
        int count2 = 0;
        for (i2 = 0; i2 < this.in.size(); ++i2) {
            if (!this.in.get(i2)) continue;
            buf.append(' ').append(i2);
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        buf.append("\n\tVars Live on Exit: ");
        count2 = 0;
        for (i2 = 0; i2 < this.out.size(); ++i2) {
            if (!this.out.get(i2)) continue;
            buf.append(' ').append(i2);
            if (++count2 % 10 != 0) continue;
            buf.append("\t\n");
        }
        if (count2 % 10 != 0) {
            buf.append("\t\t");
        }
        return buf.append('\n').toString();
    }

    void markDeadInstructions() {
        IRScope scope = ((LiveVariablesProblem)this.problem).getScope();
        boolean scopeBindingHasEscaped = scope.bindingHasEscaped();
        if (this.in == null) {
            for (Instr i2 : this.basicBlock.getInstrs()) {
                i2.markDead();
            }
            return;
        }
        this.initSolution();
        List<Instr> instrs = this.basicBlock.getInstrs();
        ListIterator<Instr> it = instrs.listIterator(instrs.size());
        while (it.hasPrevious()) {
            Instr i3 = it.previous();
            if (i3 instanceof ResultInstr) {
                Variable v = ((ResultInstr)((Object)i3)).getResult();
                Integer dv = ((LiveVariablesProblem)this.problem).getDFVar(v);
                if (this.living.get(dv)) {
                    this.living.clear(dv);
                } else if (i3.canBeDeleted(scope)) {
                    i3.markDead();
                    it.remove();
                }
            } else if (i3.canBeDeleted(scope)) {
                i3.markDead();
                it.remove();
            }
            if (i3 instanceof ClosureAcceptingInstr) {
                Operand o = ((ClosureAcceptingInstr)((Object)i3)).getClosureArg();
                if (o != null && o instanceof WrappedIRClosure) {
                    IRClosure cl = ((WrappedIRClosure)o).getClosure();
                    LiveVariablesProblem liveVariablesProblem = (LiveVariablesProblem)cl.getDataFlowSolution(((LiveVariablesProblem)this.problem).getName());
                    this.markAllVariablesLive((LiveVariablesProblem)this.problem, this.living, liveVariablesProblem.getVarsLiveOnScopeEntry());
                } else if (scopeBindingHasEscaped) {
                    for (Variable variable : ((LiveVariablesProblem)this.problem).getNonSelfLocalVars()) {
                        this.living.set(((LiveVariablesProblem)this.problem).getDFVar(variable));
                    }
                }
            }
            if (i3.canRaiseException()) {
                this.makeOutExceptionVariablesLiving(this.living);
            }
            if (i3.isDead()) continue;
            this.markAllVariablesLive((LiveVariablesProblem)this.problem, this.living, i3.getUsedVariables());
        }
    }

    BitSet getLiveInBitSet() {
        return this.in;
    }

    BitSet getLiveOutBitSet() {
        return this.out;
    }
}

