/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.ParseResult;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Interp;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryCurrentModuleVariable;
import org.jruby.ir.operands.TemporaryCurrentScopeVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalReplacementVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.TemporaryVariableType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.AddCallProtocolInstructions;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.CompilerPassScheduler;
import org.jruby.ir.passes.DeadCodeElimination;
import org.jruby.ir.passes.OptimizeDynScopesPass;
import org.jruby.ir.passes.UnboxingPass;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.representations.CFGLinearizer;
import org.jruby.ir.transformations.inlining.CFGInliner;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class IRScope
implements ParseResult {
    private static final Logger LOG = LoggerFactory.getLogger("IRScope");
    private static AtomicInteger globalScopeCount = new AtomicInteger();
    private int scopeId;
    private String name;
    private final String fileName;
    private final int lineNumber;
    private IRScope lexicalParent;
    private List<IRClosure> nestedClosures;
    private int nextClosureIndex;
    private List<IRScope> lexicalChildren;
    private StaticScope staticScope;
    private List<Instr> instrList;
    private CFG cfg;
    private Set<Variable> definedLocalVars;
    private Set<Variable> usedLocalVars;
    private Map<String, DataFlowProblem> dfProbs;
    private List<CompilerPass> executedPasses;
    protected InterpreterContext interpreterContext;
    private BasicBlock[] linearizedBBList;
    protected int temporaryVariableIndex;
    protected int floatVariableIndex;
    protected int fixnumVariableIndex;
    protected int booleanVariableIndex;
    private Map<String, Integer> nextVarIndex;
    private int instructionsOffsetInfoPersistenceBuffer = -1;
    private IRReaderDecoder persistenceStore = null;
    private TemporaryLocalVariable currentModuleVariable;
    private TemporaryLocalVariable currentScopeVariable;
    Map<String, LocalVariable> localVars;
    Map<String, LocalVariable> evalScopeVars;
    EnumSet<IRFlags> flags = EnumSet.noneOf(IRFlags.class);
    private boolean flagsComputed;
    private int threadPollInstrsCount;
    private IRManager manager;
    private TemporaryVariable yieldClosureVariable;

    protected IRScope(IRScope s2, IRScope lexicalParent) {
        this.lexicalParent = lexicalParent;
        this.manager = s2.manager;
        this.fileName = s2.fileName;
        this.lineNumber = s2.lineNumber;
        this.staticScope = s2.staticScope;
        this.threadPollInstrsCount = s2.threadPollInstrsCount;
        this.nextClosureIndex = s2.nextClosureIndex;
        this.temporaryVariableIndex = s2.temporaryVariableIndex;
        this.floatVariableIndex = s2.floatVariableIndex;
        this.instrList = new ArrayList<Instr>();
        this.nestedClosures = new ArrayList<IRClosure>();
        this.dfProbs = new HashMap<String, DataFlowProblem>();
        this.nextVarIndex = new HashMap<String, Integer>();
        this.cfg = null;
        this.interpreterContext = null;
        this.linearizedBBList = null;
        this.flagsComputed = s2.flagsComputed;
        this.flags = s2.flags.clone();
        this.localVars = new HashMap<String, LocalVariable>(s2.localVars);
        this.scopeId = globalScopeCount.getAndIncrement();
        this.executedPasses = new ArrayList<CompilerPass>();
        this.setupLexicalContainment();
    }

    public IRScope(IRManager manager, IRScope lexicalParent, String name2, String fileName, int lineNumber, StaticScope staticScope) {
        this.manager = manager;
        this.lexicalParent = lexicalParent;
        this.name = name2;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.staticScope = staticScope;
        this.threadPollInstrsCount = 0;
        this.nextClosureIndex = 0;
        this.temporaryVariableIndex = -1;
        this.floatVariableIndex = -1;
        this.instrList = new ArrayList<Instr>();
        this.nestedClosures = new ArrayList<IRClosure>();
        this.dfProbs = new HashMap<String, DataFlowProblem>();
        this.nextVarIndex = new HashMap<String, Integer>();
        this.cfg = null;
        this.interpreterContext = null;
        this.linearizedBBList = null;
        this.flagsComputed = false;
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_BREAKS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.HAS_BREAK_INSTRS);
        this.flags.remove((Object)IRFlags.HAS_END_BLOCKS);
        this.flags.remove((Object)IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
        this.flags.remove((Object)IRFlags.HAS_LOOPS);
        this.flags.remove((Object)IRFlags.HAS_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.RECEIVES_KEYWORD_ARGS);
        this.flags.add(IRFlags.CAN_CAPTURE_CALLERS_BINDING);
        this.flags.add(IRFlags.BINDING_HAS_ESCAPED);
        this.flags.add(IRFlags.USES_EVAL);
        this.flags.add(IRFlags.USES_BACKREF_OR_LASTLINE);
        this.flags.add(IRFlags.REQUIRES_DYNSCOPE);
        this.flags.add(IRFlags.USES_ZSUPER);
        this.localVars = new HashMap<String, LocalVariable>();
        this.scopeId = globalScopeCount.getAndIncrement();
        this.executedPasses = new ArrayList<CompilerPass>();
        this.setupLexicalContainment();
    }

    private final void setupLexicalContainment() {
        if (this.manager.isDryRun() || RubyInstanceConfig.IR_WRITING) {
            this.lexicalChildren = new ArrayList<IRScope>();
            if (this.lexicalParent != null) {
                this.lexicalParent.addChildScope(this);
            }
        }
    }

    private boolean hasListener() {
        return this.manager.getIRScopeListener() != null;
    }

    public int getScopeId() {
        return this.scopeId;
    }

    public int hashCode() {
        return this.scopeId;
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.scopeId == ((IRScope)other).scopeId;
    }

    protected void addChildScope(IRScope scope) {
        this.lexicalChildren.add(scope);
    }

    public List<IRScope> getLexicalScopes() {
        return this.lexicalChildren;
    }

    public void initNestedClosures() {
        this.nestedClosures = new ArrayList<IRClosure>();
    }

    public void addClosure(IRClosure closure) {
        this.nestedClosures.add(closure);
    }

    public void removeClosure(IRClosure closure) {
        this.nestedClosures.remove(closure);
    }

    public void addInstrAtBeginning(Instr instr) {
        instr.computeScopeFlags(this);
        if (this.hasListener()) {
            this.manager.getIRScopeListener().addedInstr(this, instr, 0);
        }
        this.instrList.add(0, instr);
    }

    public void addInstr(Instr instr) {
        if (instr instanceof ThreadPollInstr) {
            ++this.threadPollInstrsCount;
        }
        instr.computeScopeFlags(this);
        if (this.hasListener()) {
            this.manager.getIRScopeListener().addedInstr(this, instr, this.instrList.size());
        }
        this.instrList.add(instr);
    }

    public LocalVariable getNewFlipStateVariable() {
        return this.getLocalVariable("%flip_" + this.allocateNextPrefixedName("%flip"), 0);
    }

    public void initFlipStateVariable(Variable v, Operand initState) {
        this.addInstrAtBeginning(new CopyInstr(v, initState));
    }

    public Label getNewLabel(String prefix) {
        return new Label(prefix, this.allocateNextPrefixedName(prefix));
    }

    public Label getNewLabel() {
        return this.getNewLabel("LBL");
    }

    public List<IRClosure> getClosures() {
        return this.nestedClosures;
    }

    public IRManager getManager() {
        return this.manager;
    }

    public IRScope getLexicalParent() {
        return this.lexicalParent;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public IRMethod getNearestMethod() {
        IRScope current2;
        for (current2 = this; current2 != null && !(current2 instanceof IRMethod); current2 = current2.getLexicalParent()) {
        }
        return (IRMethod)current2;
    }

    public IRScope getNearestFlipVariableScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isFlipScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public IRScope getNearestTopLocalVariableScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isTopLocalVariableScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public int getNearestModuleReferencingScopeDepth() {
        int n = 0;
        IRScope current2 = this;
        while (!(current2 instanceof IRModuleBody)) {
            if (current2 == null || current2 instanceof IREvalScript) {
                return -1;
            }
            current2 = current2.getLexicalParent();
            ++n;
        }
        return n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public IRScope getTopLevelScope() {
        IRScope current2;
        for (current2 = this; current2 != null && !current2.isScriptScope(); current2 = current2.getLexicalParent()) {
        }
        return current2;
    }

    public boolean isNestedInClosure(IRClosure closure) {
        for (IRScope s2 = this; s2 != null && !s2.isTopLocalVariableScope(); s2 = s2.getLexicalParent()) {
            if (s2 != closure) continue;
            return true;
        }
        return false;
    }

    public void setHasLoopsFlag() {
        this.flags.add(IRFlags.HAS_LOOPS);
    }

    public boolean hasLoops() {
        return this.flags.contains((Object)IRFlags.HAS_LOOPS);
    }

    public boolean hasExplicitCallProtocol() {
        return this.flags.contains((Object)IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
    }

    public void setExplicitCallProtocolFlag() {
        this.flags.add(IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
    }

    public boolean receivesKeywordArgs() {
        return this.flags.contains((Object)IRFlags.RECEIVES_KEYWORD_ARGS);
    }

    public boolean bindingHasEscaped() {
        return this.flags.contains((Object)IRFlags.BINDING_HAS_ESCAPED);
    }

    public boolean usesBackrefOrLastline() {
        return this.flags.contains((Object)IRFlags.USES_BACKREF_OR_LASTLINE);
    }

    public boolean usesEval() {
        return this.flags.contains((Object)IRFlags.USES_EVAL);
    }

    public boolean usesZSuper() {
        return this.flags.contains((Object)IRFlags.USES_ZSUPER);
    }

    public boolean canReceiveNonlocalReturns() {
        this.computeScopeFlags();
        return this.flags.contains((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
    }

    public CFG buildCFG() {
        CFG newCFG = new CFG(this);
        newCFG.build(this.getInstrs());
        this.instrList = null;
        this.setCFG(newCFG);
        return newCFG;
    }

    protected void setCFG(CFG cfg) {
        this.cfg = cfg;
    }

    public CFG getCFG() {
        return this.cfg;
    }

    @Interp
    protected Instr[] prepareInstructions() {
        this.setupLinearization();
        SimpleCloneInfo cloneInfo = new SimpleCloneInfo(this, false);
        ArrayList<Instr> newInstrs = new ArrayList<Instr>();
        int ipc = 0;
        for (BasicBlock b2 : this.linearizedBBList) {
            b2.getLabel().setTargetPC(ipc);
            cloneInfo.getRenamedLabel(b2.getLabel()).setTargetPC(ipc);
            List<Instr> bbInstrs = b2.getInstrs();
            int bbInstrsLength = bbInstrs.size();
            for (int i2 = 0; i2 < bbInstrsLength; ++i2) {
                Instr instr = bbInstrs.get(i2);
                if (instr instanceof ReceiveSelfInstr) continue;
                Instr newInstr = instr.clone(cloneInfo);
                newInstr.setIPC(ipc);
                newInstrs.add(newInstr);
                ++ipc;
            }
        }
        this.cfg().getExitBB().getLabel().setTargetPC(ipc + 1);
        Instr[] linearizedInstrArray = newInstrs.toArray(new Instr[newInstrs.size()]);
        ipc = 0;
        for (BasicBlock b3 : this.linearizedBBList) {
            BasicBlock rescuerBB = this.cfg().getRescuerBBFor(b3);
            int rescuerPC = rescuerBB == null ? -1 : rescuerBB.getLabel().getTargetPC();
            for (Instr instr : b3.getInstrs()) {
                if (instr instanceof ReceiveSelfInstr) continue;
                linearizedInstrArray[ipc].setRPC(rescuerPC);
                ++ipc;
            }
        }
        return linearizedInstrArray;
    }

    private boolean isUnsafeScope() {
        if (this.isBeginEndBlock()) {
            return true;
        }
        List<IRClosure> beginBlocks = this.getBeginBlocks();
        if (beginBlocks != null && !beginBlocks.isEmpty()) {
            return true;
        }
        beginBlocks = this.getNearestTopLocalVariableScope().getBeginBlocks();
        return beginBlocks != null && !beginBlocks.isEmpty();
    }

    public List<CompilerPass> getExecutedPasses() {
        return this.executedPasses;
    }

    private void runCompilerPasses(List<CompilerPass> passes) {
        if (this.isUnsafeScope()) {
            passes = this.getManager().getSafePasses(this);
        }
        this.getManager();
        CompilerPassScheduler scheduler = IRManager.schedulePasses(passes);
        for (CompilerPass pass2 : scheduler) {
            pass2.run(this);
        }
        if (RubyInstanceConfig.IR_UNBOXING) {
            new UnboxingPass().run(this);
        }
    }

    private void optimizeSimpleScopes() {
        if (!this.isUnsafeScope() && !this.flags.contains((Object)IRFlags.REQUIRES_DYNSCOPE)) {
            new DeadCodeElimination().run(this);
            new OptimizeDynScopesPass().run(this);
        }
    }

    protected void initScope(boolean jitMode) {
        this.runCompilerPasses(this.getManager().getCompilerPasses(this));
        if (!jitMode && RubyInstanceConfig.IR_COMPILER_PASSES == null) {
            this.optimizeSimpleScopes();
        }
        if (this.getCFG() == null) {
            this.buildCFG();
        }
    }

    public InterpreterContext allocateInterpreterContext(Instr[] instructionList) {
        return new InterpreterContext(this, instructionList);
    }

    public synchronized InterpreterContext prepareForInterpretation() {
        if (this.interpreterContext != null) {
            return this.interpreterContext;
        }
        this.initScope(false);
        if (!this.isUnsafeScope()) {
            new AddCallProtocolInstructions().run(this);
        }
        this.interpreterContext = this.allocateInterpreterContext(this.prepareInstructions());
        return this.interpreterContext;
    }

    public synchronized List<BasicBlock> prepareForCompilation() {
        this.resetLinearizationData();
        this.initScope(true);
        this.runCompilerPasses(this.getManager().getJITPasses(this));
        return Arrays.asList(this.buildLinearization());
    }

    private void setupLinearization() {
        try {
            this.buildLinearization();
            this.depends(this.linearization());
        }
        catch (RuntimeException e) {
            LOG.error("Error linearizing cfg: ", e);
            CFG c = this.cfg();
            LOG.error("\nGraph:\n" + c.toStringGraph(), new Object[0]);
            LOG.error("\nInstructions:\n" + c.toStringInstrs(), new Object[0]);
            throw e;
        }
    }

    public Map<BasicBlock, Label> buildJVMExceptionTable() {
        HashMap<BasicBlock, Label> map = new HashMap<BasicBlock, Label>();
        for (BasicBlock bb : this.buildLinearization()) {
            BasicBlock rescueBB = this.cfg().getRescuerBBFor(bb);
            if (rescueBB == null) continue;
            map.put(bb, rescueBB.getLabel());
        }
        return map;
    }

    private static Label[] catLabels(Label[] labels, Label cat) {
        if (labels == null) {
            return new Label[]{cat};
        }
        Label[] newLabels = new Label[labels.length + 1];
        System.arraycopy(labels, 0, newLabels, 0, labels.length);
        newLabels[labels.length] = cat;
        return newLabels;
    }

    public EnumSet<IRFlags> getFlags() {
        return this.flags;
    }

    public void computeScopeFlags() {
        if (this.flagsComputed) {
            return;
        }
        this.flags.remove((Object)IRFlags.CAN_CAPTURE_CALLERS_BINDING);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_BREAKS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.HAS_BREAK_INSTRS);
        this.flags.remove((Object)IRFlags.HAS_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.USES_ZSUPER);
        this.flags.remove((Object)IRFlags.USES_EVAL);
        this.flags.remove((Object)IRFlags.USES_BACKREF_OR_LASTLINE);
        this.flags.remove((Object)IRFlags.REQUIRES_DYNSCOPE);
        if (this instanceof IREvalScript || this instanceof IRScriptBody) {
            this.flags.add(IRFlags.BINDING_HAS_ESCAPED);
        } else {
            this.flags.remove((Object)IRFlags.BINDING_HAS_ESCAPED);
        }
        if (this.cfg == null) {
            for (Instr i2 : this.getInstrs()) {
                i2.computeScopeFlags(this);
            }
        } else {
            for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
                for (Instr i3 : b2.getInstrs()) {
                    i3.computeScopeFlags(this);
                }
            }
        }
        for (IRClosure cl : this.getClosures()) {
            cl.computeScopeFlags();
            if (cl.usesEval()) {
                this.flags.add(IRFlags.CAN_RECEIVE_BREAKS);
                this.flags.add(IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
                this.flags.add(IRFlags.USES_ZSUPER);
                continue;
            }
            if (cl.flags.contains((Object)IRFlags.HAS_BREAK_INSTRS) || cl.flags.contains((Object)IRFlags.CAN_RECEIVE_BREAKS)) {
                this.flags.add(IRFlags.CAN_RECEIVE_BREAKS);
            }
            if (cl.flags.contains((Object)IRFlags.HAS_NONLOCAL_RETURNS) || cl.flags.contains((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS)) {
                this.flags.add(IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
            }
            if (!cl.usesZSuper()) continue;
            this.flags.add(IRFlags.USES_ZSUPER);
        }
        if (this.flags.contains((Object)IRFlags.CAN_RECEIVE_BREAKS) || this.flags.contains((Object)IRFlags.HAS_NONLOCAL_RETURNS) || this.flags.contains((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS) || this.flags.contains((Object)IRFlags.BINDING_HAS_ESCAPED) || this.flags.contains((Object)IRFlags.USES_ZSUPER) || this.flags.contains((Object)IRFlags.RECEIVES_KEYWORD_ARGS)) {
            this.flags.add(IRFlags.REQUIRES_DYNSCOPE);
        }
        this.flagsComputed = true;
    }

    public abstract IRScopeType getScopeType();

    public String toString() {
        return (Object)((Object)this.getScopeType()) + " " + this.getName() + "[" + this.getFileName() + ":" + this.getLineNumber() + "]";
    }

    public String toStringInstrs() {
        StringBuilder b2 = new StringBuilder();
        int i2 = 0;
        for (Instr instr : this.instrList) {
            if (i2 > 0) {
                b2.append("\n");
            }
            b2.append("  ").append(i2).append('\t').append(instr);
            ++i2;
        }
        if (!this.nestedClosures.isEmpty()) {
            b2.append("\n\n------ Closures encountered in this scope ------\n");
            for (IRClosure c : this.nestedClosures) {
                b2.append(c.toStringBody());
            }
            b2.append("------------------------------------------------\n");
        }
        return b2.toString();
    }

    public LocalVariable getSelf() {
        return Self.SELF;
    }

    public Variable getCurrentModuleVariable() {
        if (this.currentModuleVariable == null) {
            ++this.temporaryVariableIndex;
            this.currentModuleVariable = TemporaryCurrentModuleVariable.ModuleVariableFor(this.temporaryVariableIndex);
        }
        return this.currentModuleVariable;
    }

    public Variable getCurrentScopeVariable() {
        if (this.currentScopeVariable == null) {
            ++this.temporaryVariableIndex;
            this.currentScopeVariable = TemporaryCurrentScopeVariable.ScopeVariableFor(this.temporaryVariableIndex);
        }
        return this.currentScopeVariable;
    }

    public Map<String, LocalVariable> getLocalVariables() {
        return this.localVars;
    }

    public void setLocalVariables(Map<String, LocalVariable> variables) {
        this.localVars = variables;
    }

    public void setLabelIndices(Map<String, Integer> indices) {
        this.nextVarIndex = indices;
    }

    public LocalVariable lookupExistingLVar(String name2) {
        return this.localVars.get(name2);
    }

    protected LocalVariable findExistingLocalVariable(String name2, int depth) {
        return this.localVars.get(name2);
    }

    public LocalVariable getLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        } else if (lvar.getScopeDepth() != scopeDepth) {
            lvar = lvar.cloneForDepth(scopeDepth);
        }
        return lvar;
    }

    public LocalVariable getNewLocalVariable(String name2, int scopeDepth) {
        assert (scopeDepth == 0) : "Scope depth is non-zero for new-var request " + name2 + " in " + this;
        LocalVariable lvar = new LocalVariable(name2, scopeDepth, this.getStaticScope().addVariable(name2));
        this.localVars.put(name2, lvar);
        return lvar;
    }

    protected void initEvalScopeVariableAllocator(boolean reset2) {
        if (reset2 || this.evalScopeVars == null) {
            this.evalScopeVars = new HashMap<String, LocalVariable>();
        }
    }

    public TemporaryLocalVariable createTemporaryVariable() {
        return this.getNewTemporaryVariable(TemporaryVariableType.LOCAL);
    }

    public TemporaryLocalVariable getNewTemporaryVariableFor(LocalVariable var) {
        ++this.temporaryVariableIndex;
        return new TemporaryLocalReplacementVariable(var.getName(), this.temporaryVariableIndex);
    }

    public TemporaryLocalVariable getNewTemporaryVariable(TemporaryVariableType type2) {
        switch (type2) {
            case FLOAT: {
                ++this.floatVariableIndex;
                return new TemporaryFloatVariable(this.floatVariableIndex);
            }
            case FIXNUM: {
                ++this.fixnumVariableIndex;
                return new TemporaryFixnumVariable(this.fixnumVariableIndex);
            }
            case BOOLEAN: {
                ++this.booleanVariableIndex;
                return new TemporaryBooleanVariable(this.booleanVariableIndex);
            }
            case LOCAL: {
                ++this.temporaryVariableIndex;
                return this.manager.newTemporaryLocalVariable(this.temporaryVariableIndex);
            }
        }
        throw new RuntimeException("Invalid temporary variable being alloced in this scope: " + (Object)((Object)type2));
    }

    public void setTemporaryVariableCount(int count2) {
        this.temporaryVariableIndex = count2 + 1;
    }

    public TemporaryVariable getYieldClosureVariable() {
        if (this.yieldClosureVariable == null) {
            this.yieldClosureVariable = this.createTemporaryVariable();
            return this.yieldClosureVariable;
        }
        return this.yieldClosureVariable;
    }

    public TemporaryLocalVariable getNewUnboxedVariable(Class type2) {
        TemporaryVariableType varType = type2 == Float.class ? TemporaryVariableType.FLOAT : (type2 == Fixnum.class ? TemporaryVariableType.FIXNUM : (type2 == Boolean.class ? TemporaryVariableType.BOOLEAN : TemporaryVariableType.LOCAL));
        return this.getNewTemporaryVariable(varType);
    }

    public void resetTemporaryVariables() {
        this.temporaryVariableIndex = -1;
        this.floatVariableIndex = -1;
        this.fixnumVariableIndex = -1;
        this.booleanVariableIndex = -1;
    }

    public int getTemporaryVariablesCount() {
        return this.temporaryVariableIndex + 1;
    }

    public int getFloatVariablesCount() {
        return this.floatVariableIndex + 1;
    }

    public int getFixnumVariablesCount() {
        return this.fixnumVariableIndex + 1;
    }

    public int getBooleanVariablesCount() {
        return this.booleanVariableIndex + 1;
    }

    public Variable getNewInlineVariable(String inlinePrefix, Variable v) {
        if (v instanceof LocalVariable) {
            LocalVariable lv = (LocalVariable)v;
            return this.getLocalVariable(inlinePrefix + lv.getName(), lv.getScopeDepth());
        }
        return this.createTemporaryVariable();
    }

    public int getThreadPollInstrsCount() {
        return this.threadPollInstrsCount;
    }

    public int getLocalVariablesCount() {
        return this.localVars.size();
    }

    public int getUsedVariablesCount() {
        return this.getLocalVariablesCount() + this.getPrefixCountSize("%flip");
    }

    public void setUpUseDefLocalVarMaps() {
        this.definedLocalVars = new HashSet<Variable>();
        this.usedLocalVars = new HashSet<Variable>();
        for (BasicBlock bb : this.cfg().getBasicBlocks()) {
            for (Instr i2 : bb.getInstrs()) {
                Variable v;
                for (Variable v2 : i2.getUsedVariables()) {
                    if (!(v2 instanceof LocalVariable)) continue;
                    this.usedLocalVars.add(v2);
                }
                if (!(i2 instanceof ResultInstr) || !((v = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable)) continue;
                this.definedLocalVars.add(v);
            }
        }
        for (IRClosure cl : this.getClosures()) {
            cl.setUpUseDefLocalVarMaps();
        }
    }

    public boolean usesLocalVariable(Variable v) {
        if (this.usedLocalVars == null) {
            this.setUpUseDefLocalVarMaps();
        }
        if (this.usedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getClosures()) {
            if (!cl.usesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    public boolean definesLocalVariable(Variable v) {
        if (this.definedLocalVars == null) {
            this.setUpUseDefLocalVarMaps();
        }
        if (this.definedLocalVars.contains(v)) {
            return true;
        }
        for (IRClosure cl : this.getClosures()) {
            if (!cl.definesLocalVariable(v)) continue;
            return true;
        }
        return false;
    }

    public void setDataFlowSolution(String name2, DataFlowProblem p2) {
        this.dfProbs.put(name2, p2);
    }

    public DataFlowProblem getDataFlowSolution(String name2) {
        return this.dfProbs.get(name2);
    }

    public List<Instr> getInstrs() {
        if (this.persistenceStore != null) {
            this.instrList = this.persistenceStore.decodeInstructionsAt(this, this.instructionsOffsetInfoPersistenceBuffer);
        }
        if (this.cfg != null) {
            throw new RuntimeException("Please use the CFG to access this scope's instructions: " + this);
        }
        return this.instrList;
    }

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    public void resetLinearizationData() {
        this.linearizedBBList = null;
    }

    public BasicBlock[] buildLinearization() {
        if (this.linearizedBBList != null) {
            return this.linearizedBBList;
        }
        this.linearizedBBList = CFGLinearizer.linearize(this.cfg);
        return this.linearizedBBList;
    }

    public BasicBlock[] linearization() {
        this.depends(this.cfg());
        assert (this.linearizedBBList != null) : "You have not run linearization";
        return this.linearizedBBList;
    }

    protected void depends(Object obj) {
        assert (obj != null) : "Unsatisfied dependency and this depends() was set up wrong.  Use depends(build()) not depends(build).";
    }

    public CFG cfg() {
        assert (this.cfg != null) : "Trying to access build before build started";
        return this.cfg;
    }

    public void resetState() {
        this.interpreterContext = null;
        this.resetLinearizationData();
        this.cfg.resetState();
        this.flagsComputed = false;
        this.flags.add(IRFlags.CAN_CAPTURE_CALLERS_BINDING);
        this.flags.add(IRFlags.BINDING_HAS_ESCAPED);
        this.flags.add(IRFlags.USES_EVAL);
        this.flags.add(IRFlags.USES_ZSUPER);
        this.flags.remove((Object)IRFlags.HAS_BREAK_INSTRS);
        this.flags.remove((Object)IRFlags.HAS_NONLOCAL_RETURNS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_BREAKS);
        this.flags.remove((Object)IRFlags.CAN_RECEIVE_NONLOCAL_RETURNS);
        int i2 = 0;
        while (i2 < this.executedPasses.size()) {
            if (this.executedPasses.get(i2).invalidate(this)) continue;
            ++i2;
        }
    }

    public void inlineMethod(IRScope method, RubyModule implClass, int classToken, BasicBlock basicBlock, CallBase call2, boolean cloneHost) {
        this.depends(this.cfg());
        new CFGInliner(this.cfg).inlineMethod(method, implClass, classToken, basicBlock, call2, cloneHost);
        this.resetState();
        for (CompilerPass pass2 : this.getManager().getInliningCompilerPasses(this)) {
            pass2.run(this);
        }
    }

    public void recordBeginBlock(IRClosure beginBlockClosure) {
        throw new RuntimeException("BEGIN blocks cannot be added to: " + this.getClass().getName());
    }

    public List<IRClosure> getBeginBlocks() {
        return null;
    }

    public List<IRClosure> getEndBlocks() {
        return null;
    }

    protected int allocateNextPrefixedName(String prefix) {
        int index2 = this.getPrefixCountSize(prefix);
        this.nextVarIndex.put(prefix, index2 + 1);
        return index2;
    }

    public void setPrefixedNameIndexTo(String prefix, int newIndex) {
        int index2 = this.getPrefixCountSize(prefix);
        this.nextVarIndex.put(prefix, index2);
    }

    protected void resetVariableCounter(String prefix) {
        this.nextVarIndex.remove(prefix);
    }

    public Map<String, Integer> getVarIndices() {
        return this.nextVarIndex;
    }

    protected int getPrefixCountSize(String prefix) {
        Integer index2 = this.nextVarIndex.get(prefix);
        if (index2 == null) {
            return 0;
        }
        return index2;
    }

    public int getNextClosureId() {
        ++this.nextClosureIndex;
        return this.nextClosureIndex;
    }

    public boolean isBeginEndBlock() {
        return false;
    }

    public boolean isModuleBody() {
        return false;
    }

    public boolean isNonSingletonClassBody() {
        return false;
    }

    public boolean isFlipScope() {
        return true;
    }

    public boolean isTopLocalVariableScope() {
        return true;
    }

    public boolean isScriptScope() {
        return false;
    }

    public void savePersistenceInfo(int offset2, IRReaderDecoder file2) {
        this.instructionsOffsetInfoPersistenceBuffer = offset2;
        this.persistenceStore = file2;
    }
}

