/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.stringio;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"StringIO"})
public class StringIO
extends RubyObject
implements EncodingCapable {
    StringIOData ptr;
    private static final int STRIO_READABLE = 256;
    private static final int STRIO_WRITABLE = 512;
    private static final int STRIO_READWRITE = 768;
    private static ObjectAllocator STRINGIO_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new StringIO(runtime, klass);
        }
    };
    private static final int CHAR_BIT = 8;
    public static final ByteList NEWLINE = ByteList.create("\n");

    public static RubyClass createStringIOClass(Ruby runtime) {
        RubyClass stringIOClass = runtime.defineClass("StringIO", runtime.getClass("Data"), STRINGIO_ALLOCATOR);
        stringIOClass.defineAnnotatedMethods(StringIO.class);
        stringIOClass.includeModule(runtime.getEnumerable());
        if (runtime.getObject().isConstantDefined("Java")) {
            stringIOClass.defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        return stringIOClass;
    }

    @Override
    public Encoding getEncoding() {
        return this.ptr.string.getEncoding();
    }

    @Override
    public void setEncoding(Encoding e) {
        this.ptr.string.setEncoding(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        StringIO strio;
        IRubyObject val = strio = (StringIO)((RubyClass)recv2).newInstance(context, args2, Block.NULL_BLOCK);
        if (block.isGiven()) {
            try {
                val = block.yield(context, strio);
            }
            finally {
                strio.ptr.string = null;
                strio.flags &= 0xFFFFFCFF;
            }
        }
        return val;
    }

    protected StringIO(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        if (this.ptr == null) {
            this.ptr = new StringIOData();
        }
        this.strioInit(context, args2);
        return this;
    }

    private void strioInit(ThreadContext context, IRubyObject[] args2) {
        RubyString string2;
        Ruby runtime = context.runtime;
        boolean trunc = false;
        switch (args2.length) {
            case 2: {
                IRubyObject mode2 = args2[1];
                if (mode2 instanceof RubyFixnum) {
                    int flags2 = RubyFixnum.fix2int(mode2);
                    this.ptr.flags = ModeFlags.getOpenFileFlagsFor(flags2);
                    trunc = (flags2 & ModeFlags.TRUNC) != 0;
                } else {
                    String m = args2[1].convertToString().toString();
                    this.ptr.flags = OpenFile.ioModestrFmode(runtime, m);
                    trunc = m.charAt(0) == 'w';
                }
                string2 = args2[0].convertToString();
                if ((this.ptr.flags & 2) != 0 && string2.isFrozen()) {
                    throw runtime.newErrnoEACCESError("Permission denied");
                }
                if (!trunc) break;
                string2.resize(0);
                break;
            }
            case 1: {
                string2 = args2[0].convertToString();
                this.ptr.flags = string2.isFrozen() ? 1 : 3;
                break;
            }
            case 0: {
                string2 = RubyString.newEmptyString(runtime, runtime.getDefaultExternalEncoding());
                this.ptr.flags = 3;
                break;
            }
            default: {
                throw runtime.newArgumentError(args2.length, 2);
            }
        }
        this.ptr.string = string2;
        this.ptr.pos = 0;
        this.ptr.lineno = 0;
        this.flags |= (this.ptr.flags & 3) * 256;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        StringIO otherIO = (StringIO)TypeConverter.convertToType(other, context.runtime.getClass("StringIO"), "to_strio");
        if (this == otherIO) {
            return this;
        }
        this.ptr = otherIO.ptr;
        this.infectBy(otherIO);
        this.flags &= 0xFFFFFCFF;
        this.flags |= otherIO.flags & 0x300;
        return this;
    }

    @JRubyMethod(name={"binmode", "flush"})
    public IRubyObject strio_self() {
        return this;
    }

    @JRubyMethod(name={"fcntl"}, rest=true)
    public IRubyObject strio_unimpl(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("");
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject strioZero(ThreadContext context) {
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"sync="})
    public IRubyObject strioFirst(IRubyObject arg2) {
        this.checkInitialized();
        return arg2;
    }

    @JRubyMethod(name={"isatty", "tty?"})
    public IRubyObject strioFalse(ThreadContext context) {
        return context.runtime.getFalse();
    }

    @JRubyMethod(name={"pid", "fileno"})
    public IRubyObject strioNil(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject append(ThreadContext context, IRubyObject arg2) {
        this.callMethod(context, "write", arg2);
        return this;
    }

    @JRubyMethod
    public IRubyObject close(ThreadContext context) {
        this.checkInitialized();
        this.checkOpen();
        this.flags &= 0xFFFFFCFF;
        return context.nil;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.closed());
    }

    @JRubyMethod
    public IRubyObject close_read(ThreadContext context) {
        this.checkReadable();
        this.flags &= 0xFFFFFEFF;
        return context.nil;
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(!this.readable());
    }

    @JRubyMethod
    public IRubyObject close_write(ThreadContext context) {
        this.checkWritable();
        this.flags &= 0xFFFFFDFF;
        return context.nil;
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(!this.writable());
    }

    @JRubyMethod(name={"each"}, optional=2, writes={FrameField.LASTLINE})
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject line;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each", args2);
        }
        if (args2.length > 0 && !args2[args2.length - 1].isNil() && args2[args2.length - 1].checkStringType19().isNil() && RubyNumeric.num2long(args2[args2.length - 1]) == 0L) {
            throw context.runtime.newArgumentError("invalid limit: 0 for each_line");
        }
        this.checkReadable();
        while (!(line = this.getline(context, args2)).isNil()) {
            block.yieldSpecific(context, line);
        }
        return this;
    }

    @JRubyMethod(name={"each_line"}, optional=2, writes={FrameField.LASTLINE})
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", args2);
        }
        return this.each(context, args2, block);
    }

    @JRubyMethod(name={"lines"}, optional=2)
    public IRubyObject lines(ThreadContext context, IRubyObject[] args2, Block block) {
        context.runtime.getWarnings().warn("StringIO#lines is deprecated; use #each_line instead");
        return block.isGiven() ? this.each(context, args2, block) : RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, "each_line", args2);
    }

    @JRubyMethod(name={"each_byte", "bytes"})
    public IRubyObject each_byte(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_byte");
        }
        this.checkReadable();
        Ruby runtime = context.runtime;
        ByteList bytes2 = this.ptr.string.getByteList();
        while (this.ptr.pos < bytes2.length()) {
            block.yield(context, runtime.newFixnum(bytes2.get(this.ptr.pos++) & 0xFF));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_char(ThreadContext context, Block block) {
        IRubyObject c;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_char");
        }
        while (!(c = this.getc(context)).isNil()) {
            block.yieldSpecific(context, c);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject chars(ThreadContext context, Block block) {
        context.runtime.getWarnings().warn("StringIO#chars is deprecated; use #each_char instead");
        return this.each_char(context, block);
    }

    @JRubyMethod(name={"eof", "eof?"})
    public IRubyObject eof(ThreadContext context) {
        this.checkReadable();
        Ruby runtime = context.runtime;
        if (this.ptr.pos < this.ptr.string.size()) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    private boolean isEndOfString() {
        return this.ptr.pos >= this.ptr.string.size();
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc(ThreadContext context) {
        this.checkReadable();
        if (this.isEndOfString()) {
            return context.runtime.getNil();
        }
        int start2 = this.ptr.pos;
        int total2 = 1 + StringSupport.bytesToFixBrokenTrailingCharacter(this.ptr.string.getByteList(), start2 + 1);
        this.ptr.pos += total2;
        return context.runtime.newString(this.ptr.string.getByteList().makeShared(start2, total2));
    }

    @JRubyMethod(name={"getbyte"})
    public IRubyObject getbyte(ThreadContext context) {
        this.checkReadable();
        if (this.isEndOfString()) {
            return context.runtime.getNil();
        }
        int c = this.ptr.string.getByteList().get(this.ptr.pos++) & 0xFF;
        return context.runtime.newFixnum(c);
    }

    private RubyString strioSubstr(Ruby runtime, int pos2, int len) {
        RubyString str = this.ptr.string;
        ByteList strByteList = str.getByteList();
        byte[] strBytes = strByteList.getUnsafeBytes();
        Encoding enc = str.getEncoding();
        int rlen = str.size() - pos2;
        if (len > rlen) {
            len = rlen;
        }
        if (len < 0) {
            len = 0;
        }
        if (len == 0) {
            return RubyString.newEmptyString(runtime);
        }
        return RubyString.newStringShared(runtime, strBytes, strByteList.getBegin() + pos2, len, enc);
    }

    private static void bm_init_skip(int[] skip2, byte[] pat, int patPtr, int m) {
        for (int c = 0; c < 256; ++c) {
            skip2[c] = m;
        }
        while (--m > 0) {
            skip2[pat[patPtr++]] = m;
        }
    }

    private static int bm_search(byte[] little, int lstart, int llen, byte[] big, int bstart, int blen, int[] skip2) {
        for (int i2 = llen - 1; i2 < blen; i2 += skip2[big[i2 + bstart] & 0xFF]) {
            int j;
            int k = i2;
            for (j = llen - 1; j >= 0 && big[k + bstart] == little[j + lstart]; --j) {
                --k;
            }
            if (j >= 0) continue;
            return k + 1;
        }
        return -1;
    }

    @JRubyMethod(name={"gets"}, optional=2, writes={FrameField.LASTLINE})
    public IRubyObject gets(ThreadContext context, IRubyObject[] args2) {
        this.checkReadable();
        IRubyObject str = this.getline(context, args2);
        context.setLastLine(str);
        return str;
    }

    private IRubyObject getline(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject str = context.nil;
        int limit2 = -1;
        switch (args2.length) {
            case 0: {
                str = runtime.getGlobalVariables().get("$/");
                break;
            }
            case 1: {
                str = args2[0];
                if (str.isNil() || str instanceof RubyString) break;
                IRubyObject tmp = str.checkStringType19();
                if (tmp.isNil()) {
                    limit2 = RubyNumeric.num2int(str);
                    if (limit2 == 0) {
                        return runtime.newString();
                    }
                    str = runtime.getGlobalVariables().get("$/");
                    break;
                }
                str = tmp;
                break;
            }
            case 2: {
                if (!args2[0].isNil()) {
                    str = args2[0].convertToString();
                }
                if (runtime.is2_0()) {
                    if (args2[1].isNil()) break;
                    limit2 = RubyNumeric.num2int(args2[1]);
                    break;
                }
                limit2 = RubyNumeric.num2int(args2[1]);
            }
        }
        if (this.isEndOfString()) {
            return context.nil;
        }
        ByteList sByteList = this.ptr.string.getByteList();
        byte[] sBytes = sByteList.getUnsafeBytes();
        int begin2 = sByteList.getBegin();
        int s2 = begin2 + this.ptr.pos;
        int e = begin2 + sByteList.getRealSize();
        if (limit2 > 0 && s2 + limit2 < e) {
            e = sByteList.getEncoding().rightAdjustCharHead(sBytes, s2, s2 + limit2, e);
        }
        if (str.isNil()) {
            str = this.strioSubstr(runtime, this.ptr.pos, e - s2);
        } else {
            int n = ((RubyString)str).size();
            if (n == 0) {
                int p2 = s2;
                while (sBytes[p2] == 10) {
                    if (++p2 != e) continue;
                    return context.nil;
                }
                s2 = p2;
                if ((p2 = StringSupport.memchr(sBytes, p2, 10, e - p2)) != -1) {
                    e = ++p2 < e && sBytes[p2] == 10 ? p2 + 1 : p2;
                }
                str = this.strioSubstr(runtime, s2 - begin2, e - s2);
            } else if (n == 1) {
                RubyString strStr = (RubyString)str;
                ByteList strByteList = strStr.getByteList();
                int p3 = StringSupport.memchr(sBytes, s2, strByteList.get(0), e - s2);
                if (p3 != -1) {
                    e = p3 + 1;
                }
                str = this.strioSubstr(runtime, this.ptr.pos, e - s2);
            } else {
                if (n < e - s2) {
                    RubyString strStr = (RubyString)str;
                    ByteList strByteList = strStr.getByteList();
                    byte[] strBytes = strByteList.getUnsafeBytes();
                    int[] skip2 = new int[256];
                    int p4 = strByteList.getBegin();
                    StringIO.bm_init_skip(skip2, strBytes, p4, n);
                    int pos2 = StringIO.bm_search(strBytes, p4, n, sBytes, s2, e - s2, skip2);
                    if (pos2 >= 0) {
                        e = s2 + pos2 + n;
                    }
                }
                str = this.strioSubstr(runtime, this.ptr.pos, e - s2);
            }
        }
        this.ptr.pos = e - begin2;
        ++this.ptr.lineno;
        return str;
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length() {
        this.checkInitialized();
        this.checkFinalized();
        return this.getRuntime().newFixnum(this.ptr.string.size());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno(ThreadContext context) {
        return context.runtime.newFixnum(this.ptr.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(ThreadContext context, IRubyObject arg2) {
        this.ptr.lineno = RubyNumeric.fix2int(arg2);
        return context.nil;
    }

    @JRubyMethod(name={"pos", "tell"})
    public IRubyObject pos(ThreadContext context) {
        this.checkInitialized();
        return context.runtime.newFixnum(this.ptr.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject arg2) {
        this.checkInitialized();
        int p2 = RubyNumeric.fix2int(arg2);
        if (p2 < 0) {
            throw this.getRuntime().newErrnoEINVALError(arg2.toString());
        }
        this.ptr.pos = p2;
        return arg2;
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(ThreadContext context, IRubyObject[] args2) {
        return RubyIO.print(context, this, args2);
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(ThreadContext context, IRubyObject[] args2) {
        this.callMethod(context, "write", RubyKernel.sprintf(context, this, args2));
        return this.getRuntime().getNil();
    }

    private void strioExtend(int pos2, int len) {
        this.checkModifiable();
        int olen = this.ptr.string.size();
        if (pos2 + len > olen) {
            this.ptr.string.resize(pos2 + len);
            if (pos2 > olen) {
                ByteList ptrByteList = this.ptr.string.getByteList();
                Arrays.fill(ptrByteList.getUnsafeBytes(), ptrByteList.getBegin() + olen, ptrByteList.getBegin() + pos2, (byte)0);
            }
        } else {
            this.ptr.string.modify19();
        }
    }

    @JRubyMethod(name={"putc"})
    public IRubyObject putc(ThreadContext context, IRubyObject ch) {
        IRubyObject str;
        Ruby runtime = context.runtime;
        this.checkWritable();
        this.checkModifiable();
        if (ch instanceof RubyString) {
            str = ((RubyString)ch).substr19(runtime, 0, 1);
        } else {
            byte c = RubyNumeric.num2chr(ch);
            str = RubyString.newString(runtime, new byte[]{c});
        }
        this.write(context, str);
        return ch;
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(ThreadContext context, IRubyObject[] args2) {
        this.checkModifiable();
        return StringIO.puts(context, this, args2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static IRubyObject puts(ThreadContext context, IRubyObject maybeIO, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        if (args2.length == 0) {
            RubyIO.write(context, maybeIO, RubyString.newStringShared(runtime, NEWLINE));
            return runtime.getNil();
        }
        int i2 = 0;
        while (true) {
            block8: {
                RubyString line;
                block5: {
                    block6: {
                        RubyArray arr;
                        block7: {
                            if (i2 >= args2.length) {
                                return runtime.getNil();
                            }
                            line = null;
                            if (args2[i2].isNil()) break block5;
                            IRubyObject tmp = args2[i2].checkArrayType();
                            if (tmp.isNil()) break block6;
                            arr = (RubyArray)tmp;
                            if (!runtime.isInspecting(arr)) break block7;
                            line = runtime.newString("[...]");
                            break block5;
                        }
                        StringIO.inspectPuts(context, maybeIO, arr);
                        break block8;
                    }
                    line = args2[i2] instanceof RubyString ? (RubyString)args2[i2] : args2[i2].asString();
                }
                if (line != null) {
                    RubyIO.write(context, maybeIO, line);
                }
                if (line == null || !line.getByteList().endsWith(NEWLINE)) {
                    RubyIO.write(context, maybeIO, RubyString.newStringShared(runtime, NEWLINE));
                }
            }
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject inspectPuts(ThreadContext context, IRubyObject maybeIO, RubyArray array) {
        Ruby runtime = context.runtime;
        try {
            runtime.registerInspecting(array);
            IRubyObject iRubyObject = StringIO.puts(context, maybeIO, array.toJavaArray());
            return iRubyObject;
        }
        finally {
            runtime.unregisterInspecting(array);
        }
    }

    private RubyString makeString(Ruby runtime, ByteList buf, boolean setEncoding) {
        if (runtime.is1_9() && setEncoding) {
            buf.setEncoding(this.ptr.string.getEncoding());
        }
        RubyString str = RubyString.newString(runtime, buf);
        str.setTaint(true);
        return str;
    }

    private RubyString makeString(Ruby runtime, ByteList buf) {
        return this.makeString(runtime, buf, true);
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(ThreadContext context, IRubyObject[] args2) {
        int len;
        this.checkReadable();
        Ruby runtime = context.runtime;
        IRubyObject str = runtime.getNil();
        boolean binary = false;
        switch (args2.length) {
            case 2: {
                str = args2[1];
                if (!str.isNil()) {
                    str = str.convertToString();
                    ((RubyString)str).modify();
                }
            }
            case 1: {
                if (!args2[0].isNil()) {
                    len = RubyNumeric.fix2int(args2[0]);
                    if (len < 0) {
                        throw this.getRuntime().newArgumentError("negative length " + len + " given");
                    }
                    if (len > 0 && this.isEndOfString()) {
                        if (!str.isNil()) {
                            ((RubyString)str).resize(0);
                        }
                        return this.getRuntime().getNil();
                    }
                    binary = true;
                    break;
                }
            }
            case 0: {
                len = this.ptr.string.size();
                if (len <= this.ptr.pos) {
                    if (str.isNil()) {
                        str = runtime.newString();
                    } else {
                        ((RubyString)str).resize(0);
                    }
                    return str;
                }
                len -= this.ptr.pos;
                break;
            }
            default: {
                throw this.getRuntime().newArgumentError(args2.length, 0);
            }
        }
        if (str.isNil()) {
            str = this.strioSubstr(runtime, this.ptr.pos, len);
            if (binary) {
                ((RubyString)str).setEncoding(ASCIIEncoding.INSTANCE);
            }
        } else {
            int rest2 = this.ptr.string.size() - this.ptr.pos;
            if (len > rest2) {
                len = rest2;
            }
            ((RubyString)str).resize(len);
            ByteList strByteList = ((RubyString)str).getByteList();
            byte[] strBytes = strByteList.getUnsafeBytes();
            ByteList dataByteList = this.ptr.string.getByteList();
            byte[] dataBytes = dataByteList.getUnsafeBytes();
            System.arraycopy(dataBytes, dataByteList.getBegin() + this.ptr.pos, strBytes, strByteList.getBegin(), len);
            if (binary) {
                ((RubyString)str).setEncoding(ASCIIEncoding.INSTANCE);
            } else {
                ((RubyString)str).setEncoding(this.ptr.string.getEncoding());
            }
        }
        this.ptr.pos += ((RubyString)str).size();
        return str;
    }

    @JRubyMethod(name={"read_nonblock"}, optional=2)
    public IRubyObject read_nonblock(ThreadContext context, IRubyObject[] args2) {
        IRubyObject val = this.read(context, args2);
        if (val.isNil()) {
            throw context.runtime.newEOFError();
        }
        return val;
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar(ThreadContext context) {
        IRubyObject c = this.callMethod(context, "getc");
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"readbyte"})
    public IRubyObject readbyte(ThreadContext context) {
        IRubyObject c = this.callMethod(context, "getbyte");
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"readline"}, optional=1, writes={FrameField.LASTLINE})
    public IRubyObject readline(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line = this.callMethod(context, "gets", args2);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=2)
    public IRubyObject readlines(ThreadContext context, IRubyObject[] args2) {
        IRubyObject line;
        Ruby runtime = context.runtime;
        if (args2.length > 0 && !args2[args2.length - 1].isNil() && args2[args2.length - 1].checkStringType19().isNil() && RubyNumeric.num2long(args2[args2.length - 1]) == 0L) {
            throw runtime.newArgumentError("invalid limit: 0 for each_line");
        }
        RubyArray ary = runtime.newArray();
        this.checkReadable();
        while (!(line = this.getline(context, args2)).isNil()) {
            ary.append(line);
        }
        return ary;
    }

    @JRubyMethod(name={"reopen"}, required=0, optional=2)
    public IRubyObject reopen(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        if (args2.length == 1 && !(args2[0] instanceof RubyString)) {
            return this.initialize_copy(context, args2[0]);
        }
        this.strioInit(context, args2);
        return this;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind(ThreadContext context) {
        this.checkInitialized();
        this.ptr.pos = 0;
        this.ptr.lineno = 0;
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject seek(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        this.checkFrozen();
        this.checkFinalized();
        int offset2 = RubyNumeric.num2int(args2[0]);
        IRubyObject whence = context.nil;
        if (args2.length > 1 && !args2[0].isNil()) {
            whence = args2[1];
        }
        this.checkOpen();
        switch (whence.isNil() ? 0 : RubyNumeric.num2int(whence)) {
            case 0: {
                break;
            }
            case 1: {
                offset2 += this.ptr.pos;
                break;
            }
            case 2: {
                offset2 += this.ptr.string.size();
                break;
            }
            default: {
                throw runtime.newErrnoEINVALError("invalid whence");
            }
        }
        if (offset2 < 0) {
            throw runtime.newErrnoEINVALError("invalid seek value");
        }
        this.ptr.pos = offset2;
        return RubyFixnum.zero(runtime);
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject arg2) {
        this.checkFrozen();
        this.ptr.flags &= 0xFFFFFFFC;
        RubyString str = arg2.convertToString();
        this.ptr.flags = str.isFrozen() ? 1 : 3;
        this.ptr.pos = 0;
        this.ptr.lineno = 0;
        this.ptr.string = str;
        return this.ptr.string;
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string(ThreadContext context) {
        if (this.ptr.string == null) {
            return context.nil;
        }
        return this.ptr.string;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync(ThreadContext context) {
        this.checkInitialized();
        return context.runtime.getTrue();
    }

    @JRubyMethod(name={"sysread", "readpartial"}, optional=2)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args2) {
        IRubyObject val = this.callMethod(context, "read", args2);
        if (val.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return val;
    }

    public IRubyObject sysread(IRubyObject[] args2) {
        return this.sysread(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(IRubyObject len) {
        this.checkWritable();
        int l = RubyFixnum.fix2int(len);
        int plen = this.ptr.string.size();
        if (l < 0) {
            throw this.getRuntime().newErrnoEINVALError("negative legnth");
        }
        this.ptr.string.resize(l);
        ByteList buf = this.ptr.string.getByteList();
        if (plen < l) {
            Arrays.fill(buf.getUnsafeBytes(), buf.getBegin() + plen, buf.getBegin() + l, (byte)0);
        }
        return len;
    }

    @JRubyMethod(name={"ungetc"})
    public IRubyObject ungetc(ThreadContext context, IRubyObject arg2) {
        this.checkReadable();
        return this.ungetbyte(context, arg2);
    }

    private void ungetbyteCommon(int c) {
        this.ptr.string.modify();
        --this.ptr.pos;
        ByteList bytes2 = this.ptr.string.getByteList();
        if (this.isEndOfString()) {
            bytes2.length(this.ptr.pos + 1);
        }
        if (this.ptr.pos == -1) {
            bytes2.prepend((byte)c);
            this.ptr.pos = 0;
        } else {
            bytes2.set(this.ptr.pos, c);
        }
    }

    private void ungetbyteCommon(RubyString ungetBytes) {
        ByteList ungetByteList = ungetBytes.getByteList();
        int len = ungetByteList.getRealSize();
        int start2 = this.ptr.pos;
        if (len == 0) {
            return;
        }
        this.ptr.string.modify();
        start2 = len > this.ptr.pos ? 0 : this.ptr.pos - len;
        ByteList bytes2 = this.ptr.string.getByteList();
        if (this.isEndOfString()) {
            bytes2.length(Math.max(this.ptr.pos, len));
        }
        bytes2.replace(start2, this.ptr.pos - start2, ungetBytes.getByteList());
        this.ptr.pos = start2;
    }

    @JRubyMethod
    public IRubyObject ungetbyte(ThreadContext context, IRubyObject arg2) {
        this.checkReadable();
        if (arg2.isNil()) {
            return arg2;
        }
        this.checkModifiable();
        if (arg2 instanceof RubyFixnum) {
            this.ungetbyteCommon(RubyNumeric.fix2int(arg2));
        } else {
            this.ungetbyteCommon(arg2.convertToString());
        }
        return context.nil;
    }

    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(ThreadContext context, IRubyObject arg2) {
        return RubyIO.write(context, (IRubyObject)this, arg2);
    }

    @JRubyMethod(name={"write_nonblock"}, required=1, optional=1)
    public IRubyObject syswrite_nonblock(ThreadContext context, IRubyObject[] args2) {
        return this.syswrite(context, args2[0]);
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(ThreadContext context, IRubyObject arg2) {
        int len;
        this.checkWritable();
        Ruby runtime = context.runtime;
        RubyString str = arg2.asString();
        Encoding enc = this.ptr.string.getEncoding();
        Encoding enc2 = str.getEncoding();
        if (enc != enc2 && enc != EncodingUtils.ascii8bitEncoding(runtime) && enc2 != ASCIIEncoding.INSTANCE) {
            str = runtime.newString(EncodingUtils.strConvEnc(context, str.getByteList(), enc2, enc));
        }
        if ((len = str.size()) == 0) {
            return RubyFixnum.zero(runtime);
        }
        this.checkModifiable();
        int olen = this.ptr.string.size();
        if ((this.ptr.flags & 0x40) != 0) {
            this.ptr.pos = olen;
        }
        if (this.ptr.pos == olen) {
            EncodingUtils.encStrBufCat(runtime, this.ptr.string, str.getByteList(), enc);
        } else {
            this.strioExtend(this.ptr.pos, len);
            ByteList ptrByteList = this.ptr.string.getByteList();
            System.arraycopy(str.getByteList().getUnsafeBytes(), str.getByteList().getBegin(), ptrByteList.getUnsafeBytes(), ptrByteList.begin + this.ptr.pos, len);
        }
        this.ptr.string.infectBy((IRubyObject)str);
        this.ptr.string.infectBy((IRubyObject)this);
        this.ptr.pos += len;
        return RubyFixnum.newFixnum(runtime, len);
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject ext_enc) {
        Encoding enc = ext_enc.isNil() ? EncodingUtils.defaultExternalEncoding(context.runtime) : EncodingUtils.rbToEncoding(context, ext_enc);
        if (this.ptr.string.getEncoding() != enc) {
            this.ptr.string.modify();
            this.ptr.string.setEncoding(enc);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject enc, IRubyObject ignored) {
        return this.set_encoding(context, enc);
    }

    @JRubyMethod
    public IRubyObject set_encoding(ThreadContext context, IRubyObject enc, IRubyObject ignored1, IRubyObject ignored2) {
        return this.set_encoding(context, enc);
    }

    @JRubyMethod
    public IRubyObject external_encoding(ThreadContext context) {
        return context.runtime.getEncodingService().convertEncodingToRubyEncoding(this.ptr.string.getEncoding());
    }

    @JRubyMethod
    public IRubyObject internal_encoding(ThreadContext context) {
        return context.nil;
    }

    @JRubyMethod(name={"each_codepoint"})
    public IRubyObject each_codepoint(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, "each_codepoint");
        }
        this.checkReadable();
        Encoding enc = this.ptr.string.getEncoding();
        byte[] unsafeBytes = this.ptr.string.getByteList().getUnsafeBytes();
        int begin2 = this.ptr.string.getByteList().getBegin();
        while (this.ptr.pos < this.ptr.string.size()) {
            int c = StringSupport.codePoint(runtime, enc, unsafeBytes, begin2 + this.ptr.pos, unsafeBytes.length);
            int n = StringSupport.codeLength(runtime, enc, c);
            block.yield(context, runtime.newFixnum(c));
            this.ptr.pos += n;
        }
        return this;
    }

    @JRubyMethod(name={"codepoints"})
    public IRubyObject codepoints(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        runtime.getWarnings().warn("StringIO#codepoints is deprecated; use #each_codepoint");
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, this, "each_codepoint");
        }
        return this.each_codepoint(context, block);
    }

    @Override
    public void checkFrozen() {
        super.checkFrozen();
        this.checkInitialized();
    }

    private boolean readable() {
        return (this.flags & 0x100) != 0 && (this.ptr.flags & 1) != 0;
    }

    private boolean writable() {
        return (this.flags & 0x200) != 0 && (this.ptr.flags & 2) != 0;
    }

    private boolean closed() {
        return (this.flags & 0x300) == 0 || (this.ptr.flags & 3) == 0;
    }

    private void checkReadable() {
        this.checkInitialized();
        if (!this.readable()) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        this.checkInitialized();
        if (!this.writable()) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void checkModifiable() {
        this.checkFrozen();
        if (this.ptr.string.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
    }

    private void checkInitialized() {
        if (this.ptr == null) {
            throw this.getRuntime().newIOError("uninitialized stream");
        }
    }

    private void checkFinalized() {
        if (this.ptr.string == null) {
            throw this.getRuntime().newIOError("not opened");
        }
    }

    private void checkOpen() {
        if (this.closed()) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    static class StringIOData {
        RubyString string;
        int pos;
        int lineno;
        int flags;

        StringIOData() {
        }
    }
}

