/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.Ruby;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.AbstractLocalContextProvider;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.LocalContext;

public class ThreadSafeLocalContextProvider
extends AbstractLocalContextProvider {
    private volatile ConcurrentLinkedQueue<AtomicReference<LocalContext>> contextRefs = new ConcurrentLinkedQueue();
    private ThreadLocal<AtomicReference<LocalContext>> contextHolder = new ThreadLocal<AtomicReference<LocalContext>>(){

        @Override
        public AtomicReference<LocalContext> initialValue() {
            AtomicReference<LocalContext> contextRef = null;
            try {
                contextRef = new AtomicReference<LocalContext>(ThreadSafeLocalContextProvider.this.getInstance());
                ThreadSafeLocalContextProvider.this.contextRefs.add(contextRef);
                return contextRef;
            }
            catch (NullPointerException npe) {
                if (ThreadSafeLocalContextProvider.this.contextRefs == null) {
                    if (contextRef != null) {
                        contextRef.get().remove();
                    }
                    return null;
                }
                throw npe;
            }
        }
    };

    public ThreadSafeLocalContextProvider(LocalVariableBehavior behavior, boolean lazy) {
        this.behavior = behavior;
        this.lazy = lazy;
    }

    @Override
    public Ruby getRuntime() {
        return this.contextHolder.get().get().getThreadSafeRuntime();
    }

    @Override
    public BiVariableMap getVarMap() {
        return this.contextHolder.get().get().getVarMap(this);
    }

    @Override
    public Map getAttributeMap() {
        return this.contextHolder.get().get().getAttributeMap();
    }

    @Override
    public boolean isRuntimeInitialized() {
        return this.contextHolder.get().get().initialized;
    }

    @Override
    public void terminate() {
        ConcurrentLinkedQueue<AtomicReference<LocalContext>> terminated = this.contextRefs;
        this.contextRefs = null;
        if (terminated != null) {
            for (AtomicReference<LocalContext> contextRef : terminated) {
                contextRef.get().remove();
                contextRef.lazySet(null);
            }
            terminated.clear();
        }
        this.contextHolder.remove();
        this.contextHolder.set(null);
    }
}

