/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRMethod;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JITCompiler
implements JITCompilerMBean {
    private static final Logger LOG = LoggerFactory.getLogger("JITCompiler");
    public static final String RUBY_JIT_PREFIX = "rubyjit";
    public static final String CLASS_METHOD_DELIMITER = "$$";
    private final JITCounts counts = new JITCounts();
    private final ExecutorService executor;
    private final Ruby runtime;
    private final RubyInstanceConfig config;
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup().in(Ruby.class);

    public JITCompiler(Ruby runtime) {
        this.runtime = runtime;
        this.config = runtime.getInstanceConfig();
        this.executor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + runtime.getRuntimeNumber() + "-JIT", 1));
    }

    @Override
    public long getSuccessCount() {
        return this.counts.successCount.get();
    }

    @Override
    public long getCompileCount() {
        return this.counts.compiledCount.get();
    }

    @Override
    public long getFailCount() {
        return this.counts.failCount.get();
    }

    @Override
    public long getCompileTime() {
        return this.counts.compileTime.get() / 1000L;
    }

    @Override
    public long getAbandonCount() {
        return this.counts.abandonCount.get();
    }

    @Override
    public long getCodeSize() {
        return this.counts.codeSize.get();
    }

    @Override
    public long getAverageCodeSize() {
        return this.counts.averageCodeSize.get();
    }

    @Override
    public long getAverageCompileTime() {
        return this.counts.averageCompileTime.get() / 1000L;
    }

    @Override
    public long getLargestCodeSize() {
        return this.counts.largestCodeSize.get();
    }

    public void tearDown() {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public void jitThresholdReached(InterpretedIRMethod method, RubyInstanceConfig config, ThreadContext context, String className, String methodName) {
        method.setCallCount(-1);
        JITTask jitTask = new JITTask(className, method, methodName);
        if (config.getJitBackground() && config.getJitThreshold() > 0 && this.executor != null) {
            try {
                this.executor.submit(jitTask);
            }
            catch (RejectedExecutionException ree) {
                jitTask.run();
            }
        } else {
            jitTask.run();
        }
    }

    public static String getHashForString(String str) {
        return JITCompiler.getHashForBytes(RubyEncoding.encodeUTF8(str));
    }

    public static String getHashForBytes(byte[] bytes2) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(bytes2);
            byte[] digest2 = sha1.digest();
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < digest2.length; ++i2) {
                builder.append(Integer.toString((digest2[i2] & 0xFF) + 256, 16).substring(1));
            }
            return builder.toString().toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    static void log(InterpretedIRMethod method, String name2, String message2, String ... reason2) {
        String className = method.getImplementationClass().getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        StringBuilder builder = new StringBuilder(message2 + ":" + className + "." + name2 + " at " + method.getIRMethod().getFileName() + ":" + method.getIRMethod().getLineNumber());
        if (reason2.length > 0) {
            builder.append(" because of: \"");
            for (int i2 = 0; i2 < reason2.length; ++i2) {
                builder.append(reason2[i2]);
            }
            builder.append('\"');
        }
        LOG.info(builder.toString(), new Object[0]);
    }

    public static class JITClassGenerator {
        private final Ruby ruby;
        private final String packageName;
        private final String className;
        private final String methodName;
        private final String digestString;
        private final InterpretedIRMethod method;
        private final JVMVisitor visitor;
        private byte[] bytecode;
        private long compileTime;
        private String name;

        public JITClassGenerator(String className, String methodName, String key2, Ruby ruby2, InterpretedIRMethod method, JVMVisitor visitor) {
            this.packageName = JITCompiler.RUBY_JIT_PREFIX;
            this.digestString = RubyInstanceConfig.JAVA_VERSION == 51 || Options.COMPILE_INVOKEDYNAMIC.load() == true ? key2 + Math.abs(ruby2.hashCode()) : key2;
            this.className = this.packageName + "/" + className.replace('.', '/') + JITCompiler.CLASS_METHOD_DELIMITER + JavaNameMangler.mangleMethodName(methodName) + "_" + this.digestString;
            this.name = this.className.replaceAll("/", ".");
            this.methodName = methodName;
            this.ruby = ruby2;
            this.method = method;
            this.visitor = visitor;
        }

        protected void compile() {
            if (this.bytecode != null) {
                return;
            }
            long start2 = System.nanoTime();
            this.method.ensureInstrsReady();
            this.bytecode = this.visitor.compileToBytecode(this.method.getIRMethod());
            this.compileTime = System.nanoTime() - start2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateCounters(JITCounts counts) {
            counts.compiledCount.incrementAndGet();
            counts.compileTime.addAndGet(this.compileTime);
            counts.codeSize.addAndGet(this.bytecode.length);
            counts.averageCompileTime.set(counts.compileTime.get() / counts.compiledCount.get());
            counts.averageCodeSize.set(counts.codeSize.get() / counts.compiledCount.get());
            JITCounts jITCounts = counts;
            synchronized (jITCounts) {
                if (counts.largestCodeSize.get() < (long)this.bytecode.length) {
                    counts.largestCodeSize.set(this.bytecode.length);
                }
            }
        }

        public void generate() {
            this.compile();
        }

        public byte[] bytecode() {
            return this.bytecode;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.methodName + "() at " + this.method.getFile() + ":" + this.method.getLine();
        }
    }

    private class JITTask
    implements Runnable {
        private final String className;
        private final InterpretedIRMethod method;
        private final String methodName;

        public JITTask(String className, InterpretedIRMethod method, String methodName) {
            this.className = className;
            this.method = method;
            this.methodName = methodName;
        }

        @Override
        public void run() {
            try {
                if (JITCompiler.this.config.getExcludedMethods().size() > 0) {
                    IRubyObject possibleRealClass;
                    String excludeModuleName = this.className;
                    if (this.method.getImplementationClass().getMethodLocation().isSingleton() && (possibleRealClass = ((MetaClass)this.method.getImplementationClass()).getAttached()) instanceof RubyModule) {
                        excludeModuleName = "Meta:" + ((RubyModule)possibleRealClass).getName();
                    }
                    if (JITCompiler.this.config.getExcludedMethods().contains(excludeModuleName) || JITCompiler.this.config.getExcludedMethods().contains(excludeModuleName + "#" + this.methodName) || JITCompiler.this.config.getExcludedMethods().contains(this.methodName)) {
                        this.method.setCallCount(-1);
                        JITCompiler.log(this.method, this.methodName, "skipping method: " + excludeModuleName + "#" + this.methodName, new String[0]);
                        return;
                    }
                }
                String key2 = SexpMaker.sha1(this.method.getIRMethod());
                JVMVisitor visitor = new JVMVisitor();
                JITClassGenerator generator = new JITClassGenerator(this.className, this.methodName, key2, JITCompiler.this.runtime, this.method, visitor);
                generator.compile();
                Class sourceClass = visitor.defineFromBytecode(this.method.getIRMethod(), generator.bytecode(), new OneShotClassLoader(JITCompiler.this.runtime.getJRubyClassLoader()));
                if (sourceClass == null) {
                    JITCompiler.this.counts.failCount.incrementAndGet();
                    return;
                }
                generator.updateCounters(JITCompiler.this.counts);
                long methodCount = JITCompiler.this.counts.successCount.incrementAndGet();
                if (JITCompiler.this.config.getJitLogEvery() > 0 && methodCount % (long)JITCompiler.this.config.getJitLogEvery() == 0L) {
                    JITCompiler.log(this.method, this.methodName, "live compiled methods: " + methodCount, new String[0]);
                }
                if (JITCompiler.this.config.isJitLogging()) {
                    JITCompiler.log(this.method, this.className + "." + this.methodName, "done jitting", new String[0]);
                }
                Map<Integer, MethodType> signatures = ((IRMethod)this.method.getIRMethod()).getNativeSignatures();
                String jittedName = ((IRMethod)this.method.getIRMethod()).getJittedName();
                if (signatures.size() == 1) {
                    this.method.switchToJitted(new CompiledIRMethod(PUBLIC_LOOKUP.findStatic(sourceClass, jittedName, signatures.get(-1)), this.method.getIRMethod(), this.method.getVisibility(), this.method.getImplementationClass()));
                } else {
                    for (Map.Entry<Integer, MethodType> entry : signatures.entrySet()) {
                        if (entry.getKey() == -1) continue;
                        this.method.switchToJitted(new CompiledIRMethod(PUBLIC_LOOKUP.findStatic(sourceClass, jittedName, signatures.get(-1)), PUBLIC_LOOKUP.findStatic(sourceClass, jittedName, entry.getValue()), entry.getKey(), this.method.getIRMethod(), this.method.getVisibility(), this.method.getImplementationClass()));
                        break;
                    }
                }
                return;
            }
            catch (Throwable t) {
                if (JITCompiler.this.config.isJitLogging()) {
                    JITCompiler.log(this.method, this.className + "." + this.methodName, "Could not compile; passes run: " + this.method.getIRMethod().getExecutedPasses(), t.getMessage());
                    if (JITCompiler.this.config.isJitLoggingVerbose()) {
                        t.printStackTrace();
                    }
                }
                JITCompiler.this.counts.failCount.incrementAndGet();
                return;
            }
        }
    }

    public static class JITCounts {
        private final AtomicLong compiledCount = new AtomicLong(0L);
        private final AtomicLong successCount = new AtomicLong(0L);
        private final AtomicLong failCount = new AtomicLong(0L);
        private final AtomicLong abandonCount = new AtomicLong(0L);
        private final AtomicLong compileTime = new AtomicLong(0L);
        private final AtomicLong averageCompileTime = new AtomicLong(0L);
        private final AtomicLong codeSize = new AtomicLong(0L);
        private final AtomicLong averageCodeSize = new AtomicLong(0L);
        private final AtomicLong largestCodeSize = new AtomicLong(0L);
    }
}

