/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class YieldNode
extends Node {
    private final Node argsNode;
    private final boolean expandedArguments;

    public YieldNode(ISourcePosition position, Node argsNode, boolean expandedArguments) {
        super(position);
        this.argsNode = argsNode;
        this.expandedArguments = expandedArguments;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.YIELDNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitYieldNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public boolean getExpandArguments() {
        return this.expandedArguments;
    }

    @Override
    public List<Node> childNodes() {
        return YieldNode.createList(this.argsNode);
    }
}

