/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class OpElementAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node argsNode;
    private final Node valueNode;
    private final String operatorName;

    public OpElementAsgnNode(ISourcePosition position, Node receiverNode, String operatorName, Node argsNode, Node valueNode) {
        super(position);
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.argsNode = argsNode;
        this.valueNode = valueNode;
        this.operatorName = operatorName;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPELEMENTASGNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOpElementAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public boolean isOr() {
        return this.getOperatorName() == "||";
    }

    public boolean isAnd() {
        return this.getOperatorName() == "&&";
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.valueNode);
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

