/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.basic;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LayoutStrategy;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.ShapeImpl;
import com.oracle.truffle.object.basic.BasicAllocator;
import com.oracle.truffle.object.basic.BasicLayout;
import java.util.Objects;

class DefaultStrategy
implements LayoutStrategy {
    DefaultStrategy() {
    }

    @Override
    public boolean updateShape(DynamicObject object) {
        assert (object.getShape().isValid());
        return false;
    }

    @Override
    public Shape returnCached(Shape newShape) {
        assert (newShape.isValid());
        return newShape;
    }

    private static boolean assertLocationInRange(Shape shape, Location location) {
        BasicLayout layout2 = (BasicLayout)shape.getLayout();
        assert (shape.getPrimitiveFieldSize() + ((LocationImpl)location).primitiveFieldCount() <= layout2.getPrimitiveFieldCount());
        assert (shape.getObjectFieldSize() + ((LocationImpl)location).objectFieldCount() <= layout2.getObjectFieldCount());
        return true;
    }

    @Override
    public Shape ensureSpace(Shape shape, Location location) {
        Objects.requireNonNull(location);
        assert (DefaultStrategy.assertLocationInRange(shape, location));
        return shape;
    }

    @Override
    public boolean isAutoExtArray() {
        return false;
    }

    @Override
    public Property generalizeProperty(DynamicObject object, Property oldProperty, Object value2) {
        Shape oldShape = object.getShape();
        Location oldLocation = oldProperty.getLocation();
        Location newLocation = ((BasicAllocator)oldShape.allocator()).locationForValueUpcast(value2, oldLocation);
        Property newProperty = oldProperty.relocate(newLocation);
        Shape newShape = oldShape.replaceProperty(oldProperty, newProperty);
        newProperty.setSafe(object, value2, oldShape, newShape);
        return newProperty;
    }

    @Override
    public Property generalizeProperty(DynamicObject object, Property oldProperty, Object value2, Shape currentShape, Shape oldNewShape) {
        Location oldLocation = oldProperty.getLocation();
        Location newLocation = ((BasicAllocator)currentShape.allocator()).locationForValueUpcast(value2, oldLocation);
        Property newProperty = oldProperty.relocate(newLocation);
        Shape newShape = oldNewShape.replaceProperty(oldProperty, newProperty);
        newProperty.setSafe(object, value2, currentShape, newShape);
        return newProperty;
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator(Shape shape) {
        return new DefaultAllocatorImpl((ShapeImpl)shape);
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator(Layout layout2) {
        return new DefaultAllocatorImpl((LayoutImpl)layout2);
    }

    public static class DefaultAllocatorImpl
    extends BasicAllocator {
        protected DefaultAllocatorImpl(LayoutImpl layout2) {
            super(layout2);
        }

        protected DefaultAllocatorImpl(ShapeImpl shape) {
            super(shape);
        }

        @Override
        public Location locationForValue(Object value2, boolean useFinal, boolean nonNull) {
            return super.newDualLocationForValue(value2);
        }

        @Override
        public Location declaredLocation(Object value2) {
            return super.newDeclaredDualLocation(value2);
        }
    }
}

