/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.Property;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class PropertyMap
implements Map<Object, Property> {
    private final PropertyMap car;
    private final Property cdr;
    private final int size;
    private static final PropertyMap EMPTY = new PropertyMap();

    private PropertyMap() {
        this.car = null;
        this.cdr = null;
        this.size = 0;
    }

    private PropertyMap(PropertyMap parent, Property added) {
        this.car = Objects.requireNonNull(parent);
        this.cdr = added;
        this.size = parent.size + 1;
    }

    public static PropertyMap empty() {
        return EMPTY;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        for (Map.Entry<Object, Property> entry : this.reverseOrderEntrySet()) {
            if (!entry.getKey().equals(key2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value2) {
        for (Map.Entry<Object, Property> entry : this.reverseOrderEntrySet()) {
            if (!entry.getValue().equals(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Property get(Object key2) {
        for (Map.Entry<Object, Property> entry : this.reverseOrderEntrySet()) {
            if (!entry.getKey().equals(key2)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Property put(Object key2, Property value2) {
        throw PropertyMap.unmodifiableException();
    }

    @Override
    public Property remove(Object key2) {
        throw PropertyMap.unmodifiableException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Property> m) {
        throw PropertyMap.unmodifiableException();
    }

    @Override
    public void clear() {
        throw PropertyMap.unmodifiableException();
    }

    @Override
    public Set<Object> keySet() {
        return new AbstractSet<Object>(){

            @Override
            public Iterator<Object> iterator() {
                Object[] keys2 = new Object[this.size()];
                Iterator<Map.Entry<Object, Property>> iterator = PropertyMap.this.reverseOrderEntrySet().iterator();
                int pos2 = this.size() - 1;
                while (pos2 >= 0) {
                    keys2[pos2] = iterator.next().getKey();
                    --pos2;
                }
                return Arrays.asList(keys2).iterator();
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    @Override
    public Collection<Property> values() {
        return new AbstractSet<Property>(){

            @Override
            public Iterator<Property> iterator() {
                Property[] values2 = new Property[this.size()];
                Iterator<Map.Entry<Object, Property>> iterator = PropertyMap.this.reverseOrderEntrySet().iterator();
                int pos2 = this.size() - 1;
                while (pos2 >= 0) {
                    values2[pos2] = iterator.next().getValue();
                    --pos2;
                }
                return Arrays.asList(values2).iterator();
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<Object, Property>> entrySet() {
        return new AbstractSet<Map.Entry<Object, Property>>(){

            @Override
            public Iterator<Map.Entry<Object, Property>> iterator() {
                Map.Entry[] entries2 = new Map.Entry[this.size()];
                Iterator<Map.Entry<Object, Property>> iterator = PropertyMap.this.reverseOrderEntrySet().iterator();
                int pos2 = this.size() - 1;
                while (pos2 >= 0) {
                    entries2[pos2] = iterator.next();
                    --pos2;
                }
                return Arrays.asList(entries2).iterator();
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    public Set<Map.Entry<Object, Property>> reverseOrderEntrySet() {
        return new AbstractSet<Map.Entry<Object, Property>>(){

            @Override
            public Iterator<Map.Entry<Object, Property>> iterator() {
                return new Iterator<Map.Entry<Object, Property>>(){
                    PropertyMap current;
                    {
                        this.current = PropertyMap.this;
                    }

                    @Override
                    public Map.Entry<Object, Property> next() {
                        if (this.hasNext()) {
                            try {
                                MapEntryImpl mapEntryImpl = new MapEntryImpl(this.current.cdr);
                                return mapEntryImpl;
                            }
                            finally {
                                this.current = this.current.car;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != PropertyMap.empty();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    public Set<Object> reverseOrderKeys() {
        return new AbstractSet<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    PropertyMap current;
                    {
                        this.current = PropertyMap.this;
                    }

                    @Override
                    public Object next() {
                        if (this.hasNext()) {
                            try {
                                Object object = this.current.cdr.getKey();
                                return object;
                            }
                            finally {
                                this.current = this.current.car;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != PropertyMap.empty();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    public Set<Property> reverseOrderValues() {
        return new AbstractSet<Property>(){

            @Override
            public Iterator<Property> iterator() {
                return new Iterator<Property>(){
                    PropertyMap current;
                    {
                        this.current = PropertyMap.this;
                    }

                    @Override
                    public Property next() {
                        if (this.hasNext()) {
                            try {
                                Property property = this.current.cdr;
                                return property;
                            }
                            finally {
                                this.current = this.current.car;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != PropertyMap.empty();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return PropertyMap.this.size();
            }
        };
    }

    private static UnsupportedOperationException unmodifiableException() {
        throw new UnsupportedOperationException("unmodifiable");
    }

    public PropertyMap putCopy(Property value2) {
        assert (!this.containsValue(value2));
        return new PropertyMap(this, value2);
    }

    public PropertyMap removeCopy(Property value2) {
        LinkedList<Property> shelve = new LinkedList<Property>();
        PropertyMap current2 = this;
        while (!current2.isEmpty()) {
            if (current2.getLastProperty().equals(value2)) {
                PropertyMap newMap = current2.getParentMap();
                for (Property property : shelve) {
                    newMap = newMap.putCopy(property);
                }
                return newMap;
            }
            shelve.push(current2.getLastProperty());
            current2 = current2.getParentMap();
        }
        return this;
    }

    public PropertyMap replaceCopy(Property oldValue, Property newValue) {
        LinkedList<Property> shelve = new LinkedList<Property>();
        PropertyMap current2 = this;
        while (!current2.isEmpty()) {
            if (current2.getLastProperty().equals(oldValue)) {
                PropertyMap newMap = current2.getParentMap();
                newMap = newMap.putCopy(newValue);
                for (Property property : shelve) {
                    newMap = newMap.putCopy(property);
                }
                return newMap;
            }
            shelve.push(current2.getLastProperty());
            current2 = current2.getParentMap();
        }
        return this;
    }

    public PropertyMap getOwningMap(Property value2) {
        PropertyMap current2 = this;
        while (!current2.isEmpty()) {
            if (current2.getLastProperty().equals(value2)) {
                return current2;
            }
            current2 = current2.getParentMap();
        }
        return null;
    }

    PropertyMap getParentMap() {
        return this.car;
    }

    public Property getLastProperty() {
        return this.cdr;
    }

    private static final class MapEntryImpl
    implements Map.Entry<Object, Property> {
        private final Property backingProperty;

        public MapEntryImpl(Property backingProperty) {
            this.backingProperty = backingProperty;
        }

        @Override
        public Object getKey() {
            return this.backingProperty.getKey();
        }

        @Override
        public Property getValue() {
            return this.backingProperty;
        }

        @Override
        public Property setValue(Property value2) {
            throw PropertyMap.unmodifiableException();
        }
    }
}

