/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.Locations;
import java.util.EnumSet;
import java.util.Objects;

public class PropertyImpl
extends Property {
    private final Object key;
    private final Location location;
    private final int flags;
    private final boolean shadow;
    private final boolean relocatable;

    protected PropertyImpl(Object key2, Location location, int flags2, boolean shadow, boolean relocatable) {
        this.key = Objects.requireNonNull(key2);
        this.location = Objects.requireNonNull(location);
        this.flags = flags2;
        this.shadow = shadow;
        this.relocatable = relocatable;
    }

    public PropertyImpl(Object name2, Location location, int flags2) {
        this(name2, location, flags2, false, true);
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public Property relocate(Location newLocation) {
        if ((this.getLocation() == null || !this.getLocation().equals(newLocation)) && this.relocatable) {
            return this.construct(this.getKey(), newLocation, this.getFlags());
        }
        return this;
    }

    @Override
    public final Object get(DynamicObject store, Shape shape) {
        return this.getLocation().get(store, shape);
    }

    @Override
    public final Object get(DynamicObject store, boolean condition) {
        return this.getLocation().get(store, condition);
    }

    @Override
    public final void setInternal(DynamicObject store, Object value2) {
        try {
            ((LocationImpl)this.getLocation()).setInternal(store, value2);
        }
        catch (IncompatibleLocationException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public final void set(DynamicObject store, Object value2, Shape shape) throws IncompatibleLocationException, FinalLocationException {
        assert (shape == null || store.getShape() == shape) : "wrong shape";
        this.getLocation().set(store, value2, shape);
    }

    @Override
    public final void setSafe(DynamicObject store, Object value2, Shape shape) {
        assert (shape == null || store.getShape() == shape) : "wrong shape";
        try {
            this.getLocation().set(store, value2, shape);
        }
        catch (FinalLocationException | IncompatibleLocationException ex) {
            throw new IllegalStateException();
        }
    }

    @Override
    public final void setGeneric(DynamicObject store, Object value2, Shape shape) {
        assert (shape == null || store.getShape() == shape) : "wrong shape";
        try {
            this.set(store, value2, shape);
        }
        catch (FinalLocationException | IncompatibleLocationException ex) {
            this.setSlowCase(store, value2);
        }
    }

    @Override
    public final void set(DynamicObject store, Object value2, Shape oldShape, Shape newShape) throws IncompatibleLocationException {
        assert (store.getShape() == oldShape) : "wrong shape";
        assert (newShape.isValid());
        assert (this.getLocation() != null);
        this.getLocation().set(store, value2, oldShape, newShape);
    }

    @Override
    public final void setSafe(DynamicObject store, Object value2, Shape oldShape, Shape newShape) {
        assert (store.getShape() == oldShape) : "wrong old shape";
        assert (newShape.isValid());
        assert (this.getLocation() != null);
        try {
            this.getLocation().set(store, value2, oldShape, newShape);
        }
        catch (IncompatibleLocationException ex) {
            throw new IllegalStateException();
        }
    }

    @Override
    public final void setGeneric(DynamicObject store, Object value2, Shape oldShape, Shape newShape) {
        assert (store.getShape() == oldShape) : "wrong old shape";
        assert (newShape.isValid());
        assert (this.getLocation() != null);
        try {
            this.getLocation().set(store, value2, oldShape, newShape);
        }
        catch (IncompatibleLocationException ex) {
            this.setWithShapeSlowCase(store, value2, oldShape, newShape);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return this.key.equals(other.key) && (this.location == null && other.location == null || this.location != null && this.location.equals(other.location)) && this.flags == other.flags && this.shadow == other.shadow && this.relocatable == other.relocatable;
    }

    @Override
    public boolean isSame(Property obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return this.key.equals(other.key) && this.flags == other.flags;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.getClass().hashCode();
        result2 = 31 * result2 + this.key.hashCode();
        result2 = 31 * result2 + (this.location != null ? this.location.hashCode() : 0);
        result2 = 31 * result2 + this.flags;
        return result2;
    }

    public String toString() {
        return "\"" + this.key + "\"" + ":" + this.location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    private void setSlowCase(DynamicObject store, Object value2) {
        if (this.getLocation() instanceof Locations.DeclaredLocation) {
            this.setDeclaredLocation(store, value2);
        } else {
            this.generalize(store, value2);
        }
    }

    private void setDeclaredLocation(DynamicObject store, Object value2) {
        store.updateShape();
        Shape oldShape = store.getShape();
        Shape newShape = oldShape.addProperty(this.relocateShadow(oldShape.allocator().locationForValue(value2, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull))));
        store.updateShape();
        newShape.getLastProperty().setGeneric(store, value2, oldShape, newShape);
    }

    private Property generalize(DynamicObject store, Object value2) {
        return ((LayoutImpl)store.getShape().getLayout()).getStrategy().generalizeProperty(store, this, value2);
    }

    private void setWithShapeSlowCase(DynamicObject store, Object value2, Shape oldShape, Shape newShape) {
        ((LayoutImpl)store.getShape().getLayout()).getStrategy().generalizeProperty(store, this, value2, oldShape, newShape);
    }

    @Override
    public final boolean isHidden() {
        return this.key instanceof HiddenKey;
    }

    @Override
    public final boolean isShadow() {
        return this.shadow;
    }

    private Property relocateShadow(Location newLocation) {
        assert (!this.isShadow() && this.getLocation() instanceof Locations.DeclaredLocation && this.relocatable);
        return new PropertyImpl(this.getKey(), newLocation, this.flags, true, this.relocatable);
    }

    protected Property construct(Object name2, Location location, int flags2) {
        return new PropertyImpl(name2, location, flags2, this.shadow, this.relocatable);
    }

    @Override
    public Property copyWithFlags(int newFlags) {
        return this.construct(this.key, this.location, newFlags);
    }

    @Override
    public Property copyWithRelocatable(boolean newRelocatable) {
        if (this.relocatable != newRelocatable) {
            return new PropertyImpl(this.key, this.location, this.flags, this.shadow, newRelocatable);
        }
        return this;
    }
}

