/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.ValueProfile;
import java.util.Objects;

public final class IdentityValueProfile
extends ValueProfile {
    private static final Object UNINITIALIZED = new Object();
    private static final Object GENERIC = new Object();
    @CompilerDirectives.CompilationFinal
    protected Object cachedValue = UNINITIALIZED;

    IdentityValueProfile() {
    }

    @Override
    public <T> T profile(T value2) {
        if (this.cachedValue != GENERIC) {
            if (this.cachedValue == value2) {
                return (T)this.cachedValue;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cachedValue = this.cachedValue == UNINITIALIZED ? value2 : GENERIC;
        }
        return value2;
    }

    public boolean isGeneric() {
        return this.getCachedValue() == GENERIC;
    }

    public boolean isUninitialized() {
        return this.getCachedValue() == UNINITIALIZED;
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public String toString() {
        return String.format("%s(%s)@%x", this.getClass().getSimpleName(), this.isUninitialized() ? "uninitialized" : (this.isGeneric() ? "generic" : String.format("@%x", Objects.hash(this.cachedValue))), this.hashCode());
    }
}

