/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.BytesDecoder;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.SourceSection;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public abstract class Source {
    private static final Map<String, WeakReference<Source>> filePathToSource = new Hashtable<String, WeakReference<Source>>();
    private static boolean fileCacheEnabled = true;
    private TextMap textMap = null;

    public static Source fromFileName(String fileName, boolean reset2) throws IOException {
        Source source2;
        WeakReference<Source> nameRef = filePathToSource.get(fileName);
        Source source3 = source2 = nameRef == null ? null : (Source)nameRef.get();
        if (source2 == null) {
            File file2 = new File(fileName);
            if (!file2.canRead()) {
                throw new IOException("Can't read file " + fileName);
            }
            String path2 = file2.getCanonicalPath();
            WeakReference<Source> pathRef = filePathToSource.get(path2);
            Source source4 = source2 = pathRef == null ? null : (Source)pathRef.get();
            if (source2 == null) {
                source2 = new FileSource(file2, fileName, path2);
                filePathToSource.put(path2, new WeakReference<Source>(source2));
            }
        }
        if (reset2) {
            source2.reset();
        }
        return source2;
    }

    public static Source fromFileName(String fileName) throws IOException {
        return Source.fromFileName(fileName, false);
    }

    public static Source fromText(CharSequence chars2, String description) {
        assert (chars2 != null);
        return new LiteralSource(description, chars2.toString());
    }

    public static Source fromURL(URL url, String description) throws IOException {
        return URLSource.get(url, description);
    }

    public static Source fromReader(Reader reader, String description) throws IOException {
        return new LiteralSource(description, Source.read(reader));
    }

    public static Source fromBytes(byte[] bytes2, String description, BytesDecoder decoder) {
        return Source.fromBytes(bytes2, 0, bytes2.length, description, decoder);
    }

    public static Source fromBytes(byte[] bytes2, int byteIndex, int length2, String description, BytesDecoder decoder) {
        return new BytesSource(description, bytes2, byteIndex, length2, decoder);
    }

    public static Source asPseudoFile(CharSequence chars2, String pseudoFileName) {
        LiteralSource source2 = new LiteralSource(pseudoFileName, chars2.toString());
        filePathToSource.put(pseudoFileName, new WeakReference<LiteralSource>(source2));
        return source2;
    }

    public static void setFileCaching(boolean enabled) {
        fileCacheEnabled = enabled;
    }

    private static String read(Reader reader) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[1024];
        while ((n = bufferedReader.read(buffer)) != -1) {
            builder.append(buffer, 0, n);
        }
        return builder.toString();
    }

    Source() {
    }

    protected abstract void reset();

    public abstract String getName();

    public abstract String getShortName();

    public abstract String getPath();

    public abstract URL getURL();

    public abstract Reader getReader();

    public final InputStream getInputStream() {
        return new ByteArrayInputStream(this.getCode().getBytes());
    }

    public abstract String getCode();

    public String getCode(int charIndex, int charLength) {
        return this.getCode().substring(charIndex, charIndex + charLength);
    }

    public final String getCode(int lineNumber) {
        this.checkTextMap();
        int offset2 = this.textMap.lineStartOffset(lineNumber);
        int length2 = this.textMap.lineLength(lineNumber);
        return this.getCode().substring(offset2, offset2 + length2);
    }

    public final int getLineCount() {
        return this.checkTextMap().lineCount();
    }

    public final int getLineNumber(int offset2) throws IllegalArgumentException {
        return this.checkTextMap().offsetToLine(offset2);
    }

    public final int getColumnNumber(int offset2) throws IllegalArgumentException {
        return this.checkTextMap().offsetToCol(offset2);
    }

    public final int getLineStartOffset(int lineNumber) throws IllegalArgumentException {
        return this.checkTextMap().lineStartOffset(lineNumber);
    }

    public final int getLineLength(int lineNumber) throws IllegalArgumentException {
        return this.checkTextMap().lineLength(lineNumber);
    }

    public final SourceSection createSection(String identifier, int startLine, int startColumn, int charIndex, int length2) {
        return new DefaultSourceSection(this, identifier, startLine, startColumn, charIndex, length2);
    }

    public final SourceSection createSection(String identifier, int startLine, int startColumn, int length2) {
        this.checkTextMap();
        int lineStartOffset = this.textMap.lineStartOffset(startLine);
        if (startColumn > this.textMap.lineLength(startLine)) {
            throw new IllegalArgumentException("column out of range");
        }
        int startOffset = lineStartOffset + startColumn - 1;
        return new DefaultSourceSection(this, identifier, startLine, startColumn, startOffset, length2);
    }

    public final SourceSection createSection(String identifier, int charIndex, int length2) throws IllegalArgumentException {
        this.checkRange(charIndex, length2);
        this.checkTextMap();
        int startLine = this.getLineNumber(charIndex);
        int startColumn = charIndex - this.getLineStartOffset(startLine) + 1;
        return new DefaultSourceSection(this, identifier, startLine, startColumn, charIndex, length2);
    }

    protected void checkRange(int charIndex, int length2) {
        if (charIndex < 0 || length2 < 0 || charIndex + length2 > this.getCode().length()) {
            throw new IllegalArgumentException("text positions out of range");
        }
    }

    public final SourceSection createSection(String identifier, int lineNumber) {
        this.checkTextMap();
        int charIndex = this.textMap.lineStartOffset(lineNumber);
        int length2 = this.textMap.lineLength(lineNumber);
        return this.createSection(identifier, charIndex, length2);
    }

    public final LineLocation createLineLocation(int lineNumber) {
        return new LineLocationImpl(this, lineNumber);
    }

    private TextMap checkTextMap() {
        if (this.textMap == null) {
            this.textMap = this.createTextMap();
        }
        return this.textMap;
    }

    protected TextMap createTextMap() {
        String code = this.getCode();
        if (code == null) {
            throw new RuntimeException("can't read file " + this.getName());
        }
        return TextMap.fromString(code);
    }

    private static final class BytesSource
    extends Source {
        private final String name;
        private final byte[] bytes;
        private final int byteIndex;
        private final int length;
        private final BytesDecoder decoder;

        public BytesSource(String name2, byte[] bytes2, int byteIndex, int length2, BytesDecoder decoder) {
            this.name = name2;
            this.bytes = bytes2;
            this.byteIndex = byteIndex;
            this.length = length2;
            this.decoder = decoder;
        }

        @Override
        protected void reset() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.name;
        }

        @Override
        public URL getURL() {
            return null;
        }

        @Override
        public Reader getReader() {
            return null;
        }

        @Override
        public String getCode() {
            return this.decoder.decode(this.bytes, this.byteIndex, this.length);
        }

        @Override
        public String getCode(int byteOffset, int codeLength) {
            return this.decoder.decode(this.bytes, this.byteIndex + byteOffset, codeLength);
        }

        @Override
        protected void checkRange(int charIndex, int rangeLength) {
            if (charIndex < 0 || rangeLength < 0 || charIndex + rangeLength > this.length) {
                throw new IllegalArgumentException("text positions out of range");
            }
        }

        @Override
        protected TextMap createTextMap() {
            return TextMap.fromBytes(this.bytes, this.byteIndex, this.length, this.decoder);
        }
    }

    private static final class DefaultSourceSection
    implements SourceSection {
        private final Source source;
        private final String identifier;
        private final int startLine;
        private final int startColumn;
        private final int charIndex;
        private final int charLength;

        public DefaultSourceSection(Source source2, String identifier, int startLine, int startColumn, int charIndex, int charLength) {
            this.source = source2;
            this.identifier = identifier;
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.charIndex = charIndex;
            this.charLength = charLength;
        }

        @Override
        public Source getSource() {
            return this.source;
        }

        @Override
        public int getStartLine() {
            return this.startLine;
        }

        @Override
        public LineLocation getLineLocation() {
            return this.source.createLineLocation(this.startLine);
        }

        @Override
        public int getStartColumn() {
            return this.startColumn;
        }

        @Override
        public int getCharIndex() {
            return this.charIndex;
        }

        @Override
        public int getCharLength() {
            return this.charLength;
        }

        @Override
        public int getCharEndIndex() {
            return this.charIndex + this.charLength;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public String getCode() {
            return this.getSource().getCode(this.charIndex, this.charLength);
        }

        @Override
        public String getShortDescription() {
            return String.format("%s:%d", this.source.getShortName(), this.startLine);
        }

        public String toString() {
            return this.getCode();
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.charIndex;
            result2 = 31 * result2 + this.charLength;
            result2 = 31 * result2 + (this.identifier == null ? 0 : this.identifier.hashCode());
            result2 = 31 * result2 + (this.source == null ? 0 : this.source.hashCode());
            result2 = 31 * result2 + this.startColumn;
            result2 = 31 * result2 + this.startLine;
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DefaultSourceSection)) {
                return false;
            }
            DefaultSourceSection other = (DefaultSourceSection)obj;
            if (this.charIndex != other.charIndex) {
                return false;
            }
            if (this.charLength != other.charLength) {
                return false;
            }
            if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
                return false;
            }
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            if (this.startColumn != other.startColumn) {
                return false;
            }
            return this.startLine == other.startLine;
        }
    }

    private static final class FileSource
    extends Source {
        private final File file;
        private final String name;
        private final String path;
        private String code = null;
        private long timeStamp;

        public FileSource(File file2, String name2, String path2) {
            this.file = file2;
            this.name = name2;
            this.path = path2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.file.getName();
        }

        @Override
        public String getCode() {
            if (fileCacheEnabled) {
                if (this.code == null || this.timeStamp != this.file.lastModified()) {
                    try {
                        this.code = Source.read(this.getReader());
                        this.timeStamp = this.file.lastModified();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return this.code;
            }
            try {
                return Source.read(new FileReader(this.file));
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public URL getURL() {
            return null;
        }

        @Override
        public Reader getReader() {
            if (this.code != null && this.timeStamp == this.file.lastModified()) {
                return new StringReader(this.code);
            }
            try {
                return new FileReader(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Can't find file " + this.path);
            }
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof FileSource) {
                FileSource other = (FileSource)obj;
                return this.path.equals(other.path);
            }
            return false;
        }

        @Override
        protected void reset() {
            this.code = null;
        }
    }

    private static final class LineLocationImpl
    implements LineLocation {
        private final Source source;
        private final int line;

        public LineLocationImpl(Source source2, int line) {
            assert (source2 != null);
            this.source = source2;
            this.line = line;
        }

        @Override
        public Source getSource() {
            return this.source;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public String getShortDescription() {
            return String.valueOf(this.source.getShortName()) + ":" + this.line;
        }

        public String toString() {
            return "Line[" + this.getShortDescription() + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.line;
            result2 = 31 * result2 + this.source.hashCode();
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LineLocationImpl)) {
                return false;
            }
            LineLocationImpl other = (LineLocationImpl)obj;
            if (this.line != other.line) {
                return false;
            }
            return this.source.equals(other.source);
        }
    }

    private static final class LiteralSource
    extends Source {
        private final String name;
        private final String code;

        public LiteralSource(String name2, String code) {
            this.name = name2;
            this.code = code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public String getPath() {
            return this.name;
        }

        @Override
        public URL getURL() {
            return null;
        }

        @Override
        public Reader getReader() {
            return new StringReader(this.code);
        }

        @Override
        protected void reset() {
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.name.hashCode();
            result2 = 31 * result2 + (this.code == null ? 0 : this.code.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LiteralSource)) {
                return false;
            }
            LiteralSource other = (LiteralSource)obj;
            return this.name.equals(other.name) && this.code.equals(other.code);
        }
    }

    private static final class TextMap {
        private final int[] nlOffsets;
        private final int textLength;
        final boolean finalNL;

        public TextMap(int[] nlOffsets, int textLength, boolean finalNL) {
            this.nlOffsets = nlOffsets;
            this.textLength = textLength;
            this.finalNL = finalNL;
        }

        public static TextMap fromString(String text) {
            int textLength = text.length();
            ArrayList<Integer> lines2 = new ArrayList<Integer>();
            lines2.add(0);
            int offset2 = 0;
            while (offset2 < text.length()) {
                int nlIndex = text.indexOf(10, offset2);
                if (nlIndex < 0) break;
                offset2 = nlIndex + 1;
                lines2.add(offset2);
            }
            lines2.add(Integer.MAX_VALUE);
            int[] nlOffsets = new int[lines2.size()];
            int line = 0;
            while (line < lines2.size()) {
                nlOffsets[line] = (Integer)lines2.get(line);
                ++line;
            }
            boolean finalNL = textLength > 0 && textLength == nlOffsets[nlOffsets.length - 2];
            return new TextMap(nlOffsets, textLength, finalNL);
        }

        public static TextMap fromBytes(byte[] bytes2, int byteIndex, int length2, BytesDecoder bytesDecoder) {
            final ArrayList<Integer> lines2 = new ArrayList<Integer>();
            lines2.add(0);
            bytesDecoder.decodeLines(bytes2, byteIndex, length2, new BytesDecoder.LineMarker(){

                @Override
                public void markLine(int index2) {
                    lines2.add(index2);
                }
            });
            lines2.add(Integer.MAX_VALUE);
            int[] nlOffsets = new int[lines2.size()];
            int line = 0;
            while (line < lines2.size()) {
                nlOffsets[line] = (Integer)lines2.get(line);
                ++line;
            }
            boolean finalNL = length2 > 0 && length2 == nlOffsets[nlOffsets.length - 2];
            return new TextMap(nlOffsets, length2, finalNL);
        }

        public int offsetToLine(int offset2) throws IllegalArgumentException {
            if (offset2 < 0 || offset2 >= this.textLength) {
                throw new IllegalArgumentException("offset out of bounds");
            }
            int line = 1;
            while (offset2 >= this.nlOffsets[line]) {
                ++line;
            }
            return line;
        }

        public int offsetToCol(int offset2) throws IllegalArgumentException {
            return 1 + offset2 - this.nlOffsets[this.offsetToLine(offset2) - 1];
        }

        public int lineCount() {
            if (this.textLength == 0) {
                return 0;
            }
            return this.finalNL ? this.nlOffsets.length - 2 : this.nlOffsets.length - 1;
        }

        public int lineStartOffset(int line) throws IllegalArgumentException {
            if (this.textLength == 0 || this.lineOutOfRange(line)) {
                throw new IllegalArgumentException("line out of bounds");
            }
            return this.nlOffsets[line - 1];
        }

        public int lineLength(int line) throws IllegalArgumentException {
            if (this.textLength == 0 || this.lineOutOfRange(line)) {
                throw new IllegalArgumentException("line out of bounds");
            }
            if (line == this.nlOffsets.length - 1 && !this.finalNL) {
                return this.textLength - this.nlOffsets[line - 1];
            }
            return this.nlOffsets[line] - this.nlOffsets[line - 1] - 1;
        }

        private boolean lineOutOfRange(int line) {
            return line <= 0 || line >= this.nlOffsets.length || line == this.nlOffsets.length - 1 && this.finalNL;
        }
    }

    private static final class URLSource
    extends Source {
        private static final Map<URL, WeakReference<URLSource>> urlToSource = new HashMap<URL, WeakReference<URLSource>>();
        private final URL url;
        private final String name;
        private String code = null;

        public static URLSource get(URL url, String name2) throws IOException {
            URLSource source2;
            WeakReference<URLSource> sourceRef = urlToSource.get(url);
            URLSource uRLSource = source2 = sourceRef == null ? null : (URLSource)sourceRef.get();
            if (source2 == null) {
                source2 = new URLSource(url, name2);
                urlToSource.put(url, new WeakReference<URLSource>(source2));
            }
            return source2;
        }

        public URLSource(URL url, String name2) throws IOException {
            this.url = url;
            this.name = name2;
            this.code = Source.read(new InputStreamReader(url.openStream()));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.url.getPath();
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        @Override
        public Reader getReader() {
            return new StringReader(this.code);
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        protected void reset() {
        }
    }
}

