/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.LoopCountReceiver;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;

public abstract class RootNode
extends Node {
    private RootCallTarget callTarget;
    @CompilerDirectives.CompilationFinal
    private FrameDescriptor frameDescriptor;

    protected RootNode() {
        this(null, null);
    }

    protected RootNode(SourceSection sourceSection) {
        this(sourceSection, null);
    }

    protected RootNode(SourceSection sourceSection, FrameDescriptor frameDescriptor) {
        super(sourceSection);
        this.frameDescriptor = frameDescriptor == null ? new FrameDescriptor() : frameDescriptor;
    }

    @Override
    public Node copy() {
        RootNode root = (RootNode)super.copy();
        root.frameDescriptor = this.frameDescriptor;
        return root;
    }

    public boolean isCloningAllowed() {
        return false;
    }

    public final void reportLoopCount(int count2) {
        if (this.getCallTarget() instanceof LoopCountReceiver) {
            ((LoopCountReceiver)((Object)this.getCallTarget())).reportLoopCount(count2);
        }
    }

    public abstract Object execute(VirtualFrame var1);

    public final RootCallTarget getCallTarget() {
        return this.callTarget;
    }

    public final FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    public final void setCallTarget(RootCallTarget callTarget) {
        this.callTarget = callTarget;
    }

    public ExecutionContext getExecutionContext() {
        return null;
    }

    public CompilerOptions getCompilerOptions() {
        ExecutionContext context = this.getExecutionContext();
        if (context == null) {
            return DefaultCompilerOptions.INSTANCE;
        }
        return context.getCompilerOptions();
    }

    public void applyInstrumentation() {
    }
}

