/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GraphPrintVisitor {
    public static final String GraphVisualizerAddress = "127.0.0.1";
    public static final int GraphVisualizerPort = 4444;
    private Document dom;
    private Map<Object, Element> nodeMap;
    private List<Element> edgeList;
    private Map<Object, Element> prevNodeMap;
    private int id;
    private Element graphDocument;
    private Element groupElement;
    private Element graphElement;
    private Element nodesElement;
    private Element edgesElement;

    public GraphPrintVisitor() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        this.graphDocument = this.dom.createElement("graphDocument");
        this.dom.appendChild(this.graphDocument);
    }

    public GraphPrintVisitor beginGroup(String groupName) {
        this.groupElement = this.dom.createElement("group");
        this.graphDocument.appendChild(this.groupElement);
        Element properties = this.dom.createElement("properties");
        this.groupElement.appendChild(properties);
        if (!groupName.isEmpty()) {
            Element propName = this.dom.createElement("p");
            propName.setAttribute("name", "name");
            propName.setTextContent(groupName);
            properties.appendChild(propName);
        }
        this.prevNodeMap = null;
        this.nodeMap = null;
        this.edgeList = null;
        return this;
    }

    public GraphPrintVisitor beginGraph(String graphName) {
        if (this.groupElement == null) {
            this.beginGroup("");
        }
        this.graphElement = this.dom.createElement("graph");
        this.groupElement.appendChild(this.graphElement);
        Element properties = this.dom.createElement("properties");
        this.graphElement.appendChild(properties);
        this.nodesElement = this.dom.createElement("nodes");
        this.graphElement.appendChild(this.nodesElement);
        this.edgesElement = this.dom.createElement("edges");
        this.graphElement.appendChild(this.edgesElement);
        Element propName = this.dom.createElement("p");
        propName.setAttribute("name", "name");
        propName.setTextContent(graphName);
        properties.appendChild(propName);
        this.prevNodeMap = this.nodeMap;
        this.nodeMap = new HashMap<Object, Element>();
        this.edgeList = new ArrayList<Element>();
        return this;
    }

    public String toString() {
        if (this.dom != null) {
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "yes");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                StringWriter strWriter = new StringWriter();
                tr.transform(new DOMSource(this.dom), new StreamResult(strWriter));
                return strWriter.toString();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public void printToFile(File f) {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            tr.transform(new DOMSource(this.dom), new StreamResult(new FileOutputStream(f)));
        }
        catch (FileNotFoundException | TransformerException e) {
            e.printStackTrace();
        }
    }

    public void printToSysout() {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            tr.transform(new DOMSource(this.dom), new StreamResult(System.out));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void printToNetwork(boolean ignoreErrors) {
        block2: {
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("method", "xml");
                Socket socket2 = new Socket(GraphVisualizerAddress, 4444);
                BufferedOutputStream stream = new BufferedOutputStream(socket2.getOutputStream(), 16384);
                tr.transform(new DOMSource(this.dom), new StreamResult(stream));
            }
            catch (IOException | TransformerException e) {
                if (ignoreErrors) break block2;
                e.printStackTrace();
            }
        }
    }

    private String nextId() {
        return String.valueOf(this.id++);
    }

    private String oldOrNextId(Object node) {
        if (this.prevNodeMap != null && this.prevNodeMap.containsKey(node)) {
            Element nodeElem = this.prevNodeMap.get(node);
            return nodeElem.getAttribute("id");
        }
        return this.nextId();
    }

    protected Element getElementByObject(Object op) {
        return this.nodeMap.get(op);
    }

    protected void createElementForNode(Object node) {
        boolean exists = this.nodeMap.containsKey(node);
        if (!exists || NodeUtil.findAnnotation(node.getClass(), GraphDuplicate.class) != null) {
            Element nodeElem = this.dom.createElement("node");
            nodeElem.setAttribute("id", !exists ? this.oldOrNextId(node) : this.nextId());
            this.nodeMap.put(node, nodeElem);
            Element properties = this.dom.createElement("properties");
            nodeElem.appendChild(properties);
            this.nodesElement.appendChild(nodeElem);
            this.setNodeProperty(node, "name", node.getClass().getSimpleName().replaceFirst("Node$", ""));
            NodeInfo nodeInfo = node.getClass().getAnnotation(NodeInfo.class);
            if (nodeInfo != null) {
                this.setNodeProperty(node, "cost", (Object)nodeInfo.cost());
                if (!nodeInfo.shortName().isEmpty()) {
                    this.setNodeProperty(node, "shortName", nodeInfo.shortName());
                }
            }
            this.setNodeProperty(node, "class", node.getClass().getSimpleName());
            if (node instanceof Node) {
                this.readNodeProperties((Node)node);
                this.copyDebugProperties((Node)node);
            }
        }
    }

    private Element getPropertyElement(Object node, String propertyName) {
        Element nodeElem = this.getElementByObject(node);
        Element propertiesElem = (Element)nodeElem.getElementsByTagName("properties").item(0);
        if (propertiesElem == null) {
            return null;
        }
        NodeList propList = propertiesElem.getElementsByTagName("p");
        int i2 = 0;
        while (i2 < propList.getLength()) {
            Element p2 = (Element)propList.item(i2);
            if (propertyName.equals(p2.getAttribute("name"))) {
                return p2;
            }
            ++i2;
        }
        return null;
    }

    protected void setNodeProperty(Object node, String propertyName, Object value2) {
        Element nodeElem = this.getElementByObject(node);
        Element propElem = this.getPropertyElement(node, propertyName);
        if (propElem == null) {
            propElem = this.dom.createElement("p");
            propElem.setAttribute("name", propertyName);
            nodeElem.getElementsByTagName("properties").item(0).appendChild(propElem);
        }
        propElem.setTextContent(String.valueOf(value2));
    }

    private void copyDebugProperties(Node node) {
        Map<String, Object> debugProperties = node.getDebugProperties();
        for (Map.Entry<String, Object> property : debugProperties.entrySet()) {
            this.setNodeProperty(node, property.getKey(), property.getValue());
        }
    }

    private void readNodeProperties(Node node) {
        NodeUtil.NodeField[] fields2;
        NodeUtil.NodeField[] nodeFieldArray = fields2 = NodeUtil.NodeClass.get(node.getClass()).getFields();
        int n = fields2.length;
        int n2 = 0;
        while (n2 < n) {
            String key2;
            NodeUtil.NodeField field2 = nodeFieldArray[n2];
            if (field2.getKind() == NodeUtil.NodeFieldKind.DATA && this.getPropertyElement(node, key2 = field2.getName()) == null) {
                Object value2 = field2.loadValue(node);
                this.setNodeProperty(node, key2, value2);
            }
            ++n2;
        }
    }

    protected void connectNodes(Object a, Object b2, String label2) {
        if (this.nodeMap.get(a) == null || this.nodeMap.get(b2) == null) {
            return;
        }
        String fromId = this.nodeMap.get(a).getAttribute("id");
        String toId = this.nodeMap.get(b2).getAttribute("id");
        int count2 = 0;
        for (Element e : this.edgeList) {
            if (!e.getAttribute("to").equals(toId)) continue;
            ++count2;
        }
        Element edgeElem = this.dom.createElement("edge");
        edgeElem.setAttribute("from", fromId);
        edgeElem.setAttribute("to", toId);
        edgeElem.setAttribute("index", String.valueOf(count2));
        if (label2 != null) {
            edgeElem.setAttribute("label", label2);
        }
        this.edgesElement.appendChild(edgeElem);
        this.edgeList.add(edgeElem);
    }

    public GraphPrintVisitor visit(Object node) {
        if (this.graphElement == null) {
            this.beginGraph("truffle tree");
        }
        if (this.getElementByObject(node) != null && NodeUtil.findAnnotation(node.getClass(), GraphDuplicate.class) == null) {
            return this;
        }
        if (NodeUtil.findAnnotation(node.getClass(), CustomGraphPrintHandler.class) != null) {
            Class<? extends GraphPrintHandler> customHandlerClass = NodeUtil.findAnnotation(node.getClass(), CustomGraphPrintHandler.class).handler();
            try {
                GraphPrintHandler customHandler = customHandlerClass.newInstance();
                customHandler.visit(node, new GraphPrintAdapter());
            }
            catch (IllegalAccessException | InstantiationException e) {
                assert (false) : e;
            }
        } else if (NodeUtil.findAnnotation(node.getClass(), NullGraphPrintHandler.class) == null) {
            this.createElementForNode(node);
            if (node instanceof Node) {
                for (Map.Entry<String, Node> child : GraphPrintVisitor.findNamedNodeChildren((Node)node).entrySet()) {
                    this.visit(child.getValue());
                    this.connectNodes(node, child.getValue(), child.getKey());
                }
            }
        }
        return this;
    }

    private static LinkedHashMap<String, Node> findNamedNodeChildren(Node node) {
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        NodeUtil.NodeClass nodeClass = NodeUtil.NodeClass.get(node.getClass());
        NodeUtil.NodeField[] nodeFieldArray = nodeClass.getFields();
        int n = nodeFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value2;
            NodeUtil.NodeField field2 = nodeFieldArray[n2];
            NodeUtil.NodeFieldKind kind = field2.getKind();
            if ((kind == NodeUtil.NodeFieldKind.CHILD || kind == NodeUtil.NodeFieldKind.CHILDREN) && (value2 = field2.loadValue(node)) != null) {
                if (kind == NodeUtil.NodeFieldKind.CHILD) {
                    nodes.put(field2.getName(), (Node)value2);
                } else if (kind == NodeUtil.NodeFieldKind.CHILDREN) {
                    Object[] children = (Object[])value2;
                    int i2 = 0;
                    while (i2 < children.length) {
                        if (children[i2] != null) {
                            nodes.put(String.valueOf(field2.getName()) + "[" + i2 + "]", (Node)children[i2]);
                        }
                        ++i2;
                    }
                }
            }
            ++n2;
        }
        return nodes;
    }

    public static interface ChildSupplier {
        public Object startNode(Object var1);

        public void endNode(Object var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface CustomGraphPrintHandler {
        public Class<? extends GraphPrintHandler> handler();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface GraphDuplicate {
    }

    public class GraphPrintAdapter {
        public void createElementForNode(Object node) {
            GraphPrintVisitor.this.createElementForNode(node);
        }

        public void visit(Object node) {
            GraphPrintVisitor.this.visit(node);
        }

        public void connectNodes(Object node, Object child) {
            GraphPrintVisitor.this.connectNodes(node, child, null);
        }

        public void setNodeProperty(Object node, String propertyName, Object value2) {
            GraphPrintVisitor.this.setNodeProperty(node, propertyName, value2);
        }
    }

    public static interface GraphPrintHandler {
        public void visit(Object var1, GraphPrintAdapter var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface HiddenField {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface NullGraphPrintHandler {
    }
}

