/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.Truffle;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import sun.misc.Unsafe;

public final class CompilerDirectives {
    public static final double LIKELY_PROBABILITY = 0.75;
    public static final double UNLIKELY_PROBABILITY = 0.25;
    public static final double SLOWPATH_PROBABILITY = 1.0E-4;
    public static final double FASTPATH_PROBABILITY = 0.9999;
    private static final Unsafe UNSAFE = CompilerDirectives.getUnsafe();

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    public static void transferToInterpreter() {
        if (CompilerDirectives.inInterpreter()) {
            Truffle.getRuntime().notifyTransferToInterpreter();
        }
    }

    public static void transferToInterpreterAndInvalidate() {
        if (CompilerDirectives.inInterpreter()) {
            Truffle.getRuntime().notifyTransferToInterpreter();
        }
    }

    public static boolean inInterpreter() {
        return true;
    }

    public static boolean inCompiledCode() {
        return false;
    }

    public static boolean isCompilationConstant(Object value2) {
        return false;
    }

    public static void interpreterOnly(Runnable runnable) {
        runnable.run();
    }

    public static <T> T interpreterOnly(Callable<T> callable) throws Exception {
        return callable.call();
    }

    public static boolean injectBranchProbability(double probability, boolean condition) {
        assert (probability >= 0.0 && probability <= 1.0);
        return condition;
    }

    public static void bailout(String reason2) {
    }

    public static <T> T unsafeCast(Object value2, Class<T> type2, boolean condition) {
        return CompilerDirectives.unsafeCast(value2, type2, condition, false);
    }

    public static <T> T unsafeCast(Object value2, Class<T> type2, boolean condition, boolean nonNull) {
        return (T)value2;
    }

    public static boolean unsafeGetBoolean(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getBoolean(receiver2, offset2);
    }

    public static byte unsafeGetByte(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getByte(receiver2, offset2);
    }

    public static short unsafeGetShort(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getShort(receiver2, offset2);
    }

    public static int unsafeGetInt(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getInt(receiver2, offset2);
    }

    public static long unsafeGetLong(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getLong(receiver2, offset2);
    }

    public static float unsafeGetFloat(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getFloat(receiver2, offset2);
    }

    public static double unsafeGetDouble(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getDouble(receiver2, offset2);
    }

    public static Object unsafeGetObject(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getObject(receiver2, offset2);
    }

    public static void unsafePutBoolean(Object receiver2, long offset2, boolean value2, Object locationIdentity) {
        UNSAFE.putBoolean(receiver2, offset2, value2);
    }

    public static void unsafePutByte(Object receiver2, long offset2, byte value2, Object locationIdentity) {
        UNSAFE.putByte(receiver2, offset2, value2);
    }

    public static void unsafePutShort(Object receiver2, long offset2, short value2, Object locationIdentity) {
        UNSAFE.putShort(receiver2, offset2, value2);
    }

    public static void unsafePutInt(Object receiver2, long offset2, int value2, Object locationIdentity) {
        UNSAFE.putInt(receiver2, offset2, value2);
    }

    public static void unsafePutLong(Object receiver2, long offset2, long value2, Object locationIdentity) {
        UNSAFE.putLong(receiver2, offset2, value2);
    }

    public static void unsafePutFloat(Object receiver2, long offset2, float value2, Object locationIdentity) {
        UNSAFE.putFloat(receiver2, offset2, value2);
    }

    public static void unsafePutDouble(Object receiver2, long offset2, double value2, Object locationIdentity) {
        UNSAFE.putDouble(receiver2, offset2, value2);
    }

    public static void unsafePutObject(Object receiver2, long offset2, Object value2, Object locationIdentity) {
        UNSAFE.putObject(receiver2, offset2, value2);
    }

    public static boolean unsafeGetFinalBoolean(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getBoolean(receiver2, offset2);
    }

    public static byte unsafeGetFinalByte(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getByte(receiver2, offset2);
    }

    public static short unsafeGetFinalShort(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getShort(receiver2, offset2);
    }

    public static int unsafeGetFinalInt(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getInt(receiver2, offset2);
    }

    public static long unsafeGetFinalLong(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getLong(receiver2, offset2);
    }

    public static float unsafeGetFinalFloat(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getFloat(receiver2, offset2);
    }

    public static double unsafeGetFinalDouble(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getDouble(receiver2, offset2);
    }

    public static Object unsafeGetFinalObject(Object receiver2, long offset2, boolean condition, Object locationIdentity) {
        return UNSAFE.getObject(receiver2, offset2);
    }

    public static void materialize(Object obj) {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface CompilationFinal {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface TruffleBoundary {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ValueType {
    }
}

