/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jruby.ir.IRScope;
import org.jruby.ir.passes.CFGBuilder;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class DominatorTreeBuilder
extends CompilerPass {
    private static final Logger LOG = LoggerFactory.getLogger("DominatorTreeBuilder");
    public static List<Class<? extends CompilerPass>> DEPENDENCIES = Arrays.asList(CFGBuilder.class);

    @Override
    public String getLabel() {
        return "Build Dominator Tree";
    }

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public Object execute(IRScope scope, Object ... data2) {
        CFG cfg = (CFG)data2[0];
        try {
            this.buildDominatorTree(cfg, cfg.postOrderList(), cfg.getMaxNodeID());
        }
        catch (Exception e) {
            LOG.debug("Caught exception building dom tree for {}", scope.cfg());
        }
        return null;
    }

    @Override
    public void invalidate(IRScope scope) {
    }

    public void buildDominatorTree(CFG cfg, LinkedList<BasicBlock> postOrderList, int maxNodeId) {
        Integer rootPoNumber;
        Integer[] bbToPoNumbers = new Integer[maxNodeId + 1];
        BasicBlock[] poNumbersToBB = new BasicBlock[maxNodeId + 1];
        int n = 0;
        ListIterator<Object> it = postOrderList.listIterator();
        while (it.hasNext()) {
            BasicBlock b = (BasicBlock)it.next();
            bbToPoNumbers[b.getID()] = n;
            poNumbersToBB[n] = b;
            ++n;
        }
        Integer[] idoms = new Integer[maxNodeId + 1];
        BasicBlock root = cfg.getEntryBB();
        idoms[rootPoNumber.intValue()] = rootPoNumber = bbToPoNumbers[root.getID()];
        boolean changed = true;
        while (changed) {
            changed = false;
            it = postOrderList.listIterator(cfg.size());
            while (it.hasPrevious()) {
                BasicBlock b = (BasicBlock)it.previous();
                if (b == root) continue;
                Integer bPoNumber = bbToPoNumbers[b.getID()];
                Integer oldBIdom = idoms[bPoNumber];
                Integer newBIdom = null;
                for (BasicBlock src : cfg.getIncomingSources(b)) {
                    Integer srcPoNumber = bbToPoNumbers[src.getID()];
                    if (idoms[srcPoNumber] == null) continue;
                    newBIdom = srcPoNumber;
                    break;
                }
                assert (newBIdom != null);
                Integer processedPred = newBIdom;
                for (BasicBlock src : cfg.getIncomingSources(b)) {
                    Integer srcPoNumber = bbToPoNumbers[src.getID()];
                    Integer srcIdom = idoms[srcPoNumber];
                    if (srcIdom == null || srcPoNumber == processedPred) continue;
                    newBIdom = this.intersectDomSets(idoms, srcPoNumber, newBIdom);
                }
                if (oldBIdom == newBIdom) continue;
                changed = true;
                idoms[bPoNumber.intValue()] = newBIdom;
            }
        }
        HashMap<BasicBlock, BasicBlock> idomMap = new HashMap<BasicBlock, BasicBlock>();
        Integer i2 = 0;
        while (i2 < maxNodeId) {
            idomMap.put(poNumbersToBB[i2], poNumbersToBB[idoms[i2]]);
            Integer n2 = i2;
            Integer n3 = i2 = Integer.valueOf(i2 + 1);
        }
    }

    private Integer intersectDomSets(Integer[] idomMap, Integer nb1, Integer nb2) {
        while (nb1 != nb2) {
            while (nb1 < nb2) {
                nb1 = idomMap[nb1];
            }
            while (nb2 < nb1) {
                nb2 = idomMap[nb2];
            }
        }
        return nb1;
    }
}

