/*
 * Decompiled with CFR 0.152.
 */
package jay.yydebug;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.PrintStream;
import jay.yydebug.yyAnimPanel;
import jay.yydebug.yyDebug;
import jay.yydebug.yyInputStream;
import jay.yydebug.yyPrintStream;

public class yyAnim
extends Frame
implements yyDebug {
    protected static int nFrames;
    public static final int IN = 1;
    public static final int OUT = 2;
    protected yyAnimPanel panel;
    protected Thread eventThread;
    protected boolean outputBreak;

    public yyAnim(String title, int io2) {
        this(System.class, title, io2);
    }

    public yyAnim(final Class system2, String title, int io2) {
        super(title);
        ++nFrames;
        this.outputBreak = false;
        Font font = new Font("Monospaced", 0, 12);
        MenuBar mb = new MenuBar();
        Menu m = new Menu("yyAnim");
        MenuItem mi = new MenuItem("Quit");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    system2.getMethod("exit", Integer.TYPE).invoke(null, new Integer(0));
                }
                catch (Exception e) {
                    System.exit(0);
                }
            }
        });
        m.add(mi);
        mb.add(m);
        this.setMenuBar(mb);
        this.panel = new yyAnimPanel(font);
        this.add((Component)this.panel, "Center");
        if ((io2 & 3) != 0) {
            Panel p2 = new Panel(new BorderLayout());
            switch (io2) {
                case 1: {
                    p2.add((Component)new Label("terminal input"), "North");
                    break;
                }
                case 2: 
                case 3: {
                    String ct = (io2 & 1) != 0 ? "terminal i/o" : "terminal output";
                    Checkbox c = new Checkbox(ct, this.outputBreak);
                    p2.add((Component)c, "North");
                    c.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent ie) {
                            yyAnim.this.eventThread = Thread.currentThread();
                            yyAnim.this.outputBreak = ie.getStateChange() == 1;
                        }
                    });
                }
            }
            final TextArea t = new TextArea(10, 50);
            p2.add((Component)t, "Center");
            t.setBackground(Color.white);
            t.setFont(font);
            if ((io2 & 1) != 0) {
                yyInputStream in = new yyInputStream();
                t.addKeyListener(in);
                t.setEditable(true);
                try {
                    system2.getMethod("setIn", InputStream.class).invoke(null, in);
                }
                catch (Exception e) {
                    System.setIn(in);
                }
            }
            if ((io2 & 2) != 0) {
                yyPrintStream out = new yyPrintStream(){

                    public void close() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void write(byte[] b, int off, int len) {
                        String s2 = new String(b, off, len);
                        t.append(s2);
                        t.setCaretPosition(t.getText().length());
                        if (yyAnim.this.outputBreak && s2.indexOf("\n") >= 0 && yyAnim.this.eventThread != null && Thread.currentThread() != yyAnim.this.eventThread) {
                            try {
                                yyAnimPanel yyAnimPanel2 = yyAnim.this.panel;
                                synchronized (yyAnimPanel2) {
                                    yyAnim.this.panel.wait();
                                }
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                        }
                    }

                    public void write(int b) {
                        this.write(new byte[]{(byte)b}, 0, 1);
                    }
                };
                try {
                    system2.getMethod("setOut", PrintStream.class).invoke(null, out);
                }
                catch (Exception e) {
                    System.setOut(out);
                }
                try {
                    system2.getMethod("setErr", PrintStream.class).invoke(null, out);
                }
                catch (Exception e) {
                    System.setErr(out);
                }
            }
            this.add((Component)p2, "South");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                yyAnim.this.dispose();
                if (--nFrames <= 0) {
                    try {
                        system2.getMethod("exit", Integer.TYPE).invoke(null, new Integer(0));
                    }
                    catch (Exception e) {
                        System.exit(0);
                    }
                }
            }
        });
        this.pack();
        yyAnim.setStaggeredLocation(this);
        this.show();
    }

    public static void setStaggeredLocation(Component c) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = c.getPreferredSize();
        int x = (screen.width - d.width) / 2 + (nFrames - 1) * 32;
        if (x < 32) {
            x = 32;
        } else if (x > screen.width - 128) {
            x = screen.width - 128;
        }
        int y = (screen.height - d.height) / 2 + (nFrames - 1) * 32;
        if (y < 32) {
            y = 32;
        } else if (y > screen.height - 128) {
            y = screen.height - 128;
        }
        c.setLocation(x, y);
    }

    public synchronized void lex(int state2, int token, String name2, Object value2) {
        this.panel.lex(state2, token, name2, value2);
    }

    public void shift(int from, int to, int errorFlag) {
        this.panel.shift(from, to, errorFlag);
    }

    public void discard(int state2, int token, String name2, Object value2) {
        this.panel.discard(state2, token, name2, value2);
    }

    public void shift(int from, int to) {
        this.panel.shift(from, to);
    }

    public synchronized void accept(Object value2) {
        this.panel.accept(value2);
    }

    public void error(String message2) {
        this.panel.error(message2);
    }

    public void reject() {
        this.panel.reject();
    }

    public synchronized void push(int state2, Object value2) {
        this.panel.push(state2, value2);
    }

    public synchronized void pop(int state2) {
        this.panel.pop(state2);
    }

    public synchronized void reduce(int from, int to, int rule, String text, int len) {
        this.panel.reduce(from, to, rule, text, len);
    }
}

