/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ir.operands.Label;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class ExceptionRegion {
    private Label ensureBlockLabel;
    private Label firstRescueBlockLabel;
    private List<BasicBlock> exclusiveBBs;
    private List<ExceptionRegion> nestedRegions;
    private BasicBlock startBB;
    private BasicBlock endBB;
    private BasicBlock firstRescueBB;

    public ExceptionRegion(Label firstRescueBlockLabel, Label ensureBlockLabel, BasicBlock startBB) {
        this.firstRescueBlockLabel = firstRescueBlockLabel;
        this.ensureBlockLabel = ensureBlockLabel;
        this.startBB = startBB;
        this.exclusiveBBs = new ArrayList<BasicBlock>();
        this.nestedRegions = new ArrayList<ExceptionRegion>();
    }

    public void setEndBB(BasicBlock bb) {
        this.endBB = bb;
    }

    public Label getEnsureBlockLabel() {
        return this.ensureBlockLabel;
    }

    public BasicBlock getStartBB() {
        return this.startBB;
    }

    public BasicBlock getEndBB() {
        return this.endBB;
    }

    public List<BasicBlock> getExclusiveBBs() {
        return this.exclusiveBBs;
    }

    public void addBB(BasicBlock bb) {
        this.exclusiveBBs.add(bb);
    }

    public void addNestedRegion(ExceptionRegion r) {
        this.nestedRegions.add(r);
        this.exclusiveBBs.remove(r.exclusiveBBs.get(0));
    }

    public void mergeBBs(BasicBlock a, BasicBlock b) {
        this.exclusiveBBs.remove(b);
        if (this.endBB == b) {
            this.endBB = a;
        }
        for (ExceptionRegion er : this.nestedRegions) {
            er.mergeBBs(a, b);
        }
    }

    public void setFirstRescueBB(BasicBlock frbb) {
        this.firstRescueBB = frbb;
    }

    public Label getFirstRescueBlockLabel() {
        return this.firstRescueBlockLabel;
    }

    public ExceptionRegion cloneForInlining(InlinerInfo ii) {
        ExceptionRegion newR = new ExceptionRegion(ii.getRenamedLabel(this.firstRescueBlockLabel), this.ensureBlockLabel == null ? null : ii.getRenamedLabel(this.ensureBlockLabel), ii.getRenamedBB(this.startBB));
        newR.endBB = ii.getRenamedBB(this.endBB);
        newR.firstRescueBB = ii.getRenamedBB(this.firstRescueBB);
        for (BasicBlock b : this.exclusiveBBs) {
            newR.addBB(ii.getRenamedBB(b));
        }
        for (ExceptionRegion r : this.nestedRegions) {
            newR.addNestedRegion(r.cloneForInlining(ii));
        }
        return newR;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("--- Exception Region ---");
        buf.append("\n");
        buf.append("Exclusive BBs\n");
        for (BasicBlock b : this.exclusiveBBs) {
            buf.append("\t");
            buf.append(b);
            buf.append("\n");
        }
        buf.append("End: ");
        buf.append(this.endBB.getLabel());
        buf.append("\n");
        buf.append("Rescuer: ");
        buf.append(this.firstRescueBlockLabel);
        buf.append("\n");
        if (this.ensureBlockLabel != null) {
            buf.append("Ensurer: ");
            buf.append(this.ensureBlockLabel);
            buf.append("\n");
        }
        buf.append("\n");
        for (ExceptionRegion er : this.nestedRegions) {
            buf.append(er.toString());
        }
        return buf.toString();
    }
}

