/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.jruby.runtime.invokedynamic.Signature;

public class SmartHandle {
    private final Signature signature;
    private final MethodHandle handle;

    public SmartHandle(Signature signature, MethodHandle handle) {
        this.signature = signature;
        this.handle = handle;
    }

    public static SmartHandle findStaticQuiet(MethodHandles.Lookup lookup, Class target, String name2, Signature signature) {
        try {
            return new SmartHandle(signature, lookup.findStatic(target, name2, signature.methodType()));
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
        catch (IllegalAccessException nae) {
            throw new RuntimeException(nae);
        }
    }

    public Signature signature() {
        return this.signature;
    }

    public MethodHandle handle() {
        return this.handle;
    }

    public SmartHandle insert(int index2, String name2, Object arg2) {
        return new SmartHandle(this.signature.insertArg(0, name2, arg2.getClass()), MethodHandles.insertArguments(this.handle, index2, arg2));
    }

    public SmartHandle insert(int index2, String name2, boolean arg2) {
        return new SmartHandle(this.signature.insertArg(0, name2, Boolean.TYPE), MethodHandles.insertArguments(this.handle, index2, arg2));
    }

    public SmartHandle insert(int index2, String name2, byte arg2) {
        return new SmartHandle(this.signature.insertArg(0, name2, Byte.TYPE), MethodHandles.insertArguments(this.handle, index2, arg2));
    }

    public SmartHandle insert(int index2, String name2, short arg2) {
        return new SmartHandle(this.signature.insertArg(0, name2, Short.TYPE), MethodHandles.insertArguments(this.handle, index2, arg2));
    }

    public SmartHandle insert(int index2, String name2, char arg2) {
        return new SmartHandle(this.signature.insertArg(0, name2, Character.TYPE), MethodHandles.insertArguments(this.handle, index2, Character.valueOf(arg2)));
    }

    public SmartHandle insert(int index2, String name2, int arg2) {
        return new SmartHandle(this.signature.insertArg(0, name2, Integer.TYPE), MethodHandles.insertArguments(this.handle, index2, arg2));
    }

    public SmartHandle insert(int index2, String name2, long arg2) {
        return new SmartHandle(this.signature.insertArg(0, name2, Long.TYPE), MethodHandles.insertArguments(this.handle, index2, arg2));
    }

    public SmartHandle insert(int index2, String name2, float arg2) {
        return new SmartHandle(this.signature.insertArg(0, name2, Float.TYPE), MethodHandles.insertArguments(this.handle, index2, Float.valueOf(arg2)));
    }

    public SmartHandle insert(int index2, String name2, double arg2) {
        return new SmartHandle(this.signature.insertArg(0, name2, Double.TYPE), MethodHandles.insertArguments(this.handle, index2, arg2));
    }

    public MethodHandle guard(MethodHandle target, MethodHandle fallback) {
        return MethodHandles.guardWithTest(this.handle, target, fallback);
    }

    public SmartHandle guard(SmartHandle target, SmartHandle fallback) {
        return new SmartHandle(target.signature, MethodHandles.guardWithTest(this.handle, target.handle, fallback.handle));
    }
}

