/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.ir.IRClosure;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedIRBlockBody
extends ContextAwareBlockBody {
    protected final IRClosure closure;

    public InterpretedIRBlockBody(IRClosure closure, Arity arity2, int argumentType) {
        super(closure.getStaticScope(), arity2, argumentType);
        this.closure = closure;
    }

    @Override
    public IRubyObject call(ThreadContext context, Binding binding2, Block.Type type2) {
        return this.call(context, IRubyObject.NULL_ARRAY, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{arg0}, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{arg0, arg1}, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
        return this.call(context, new IRubyObject[]{arg0, arg1, arg2}, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.call(context, args2, binding2, type2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        return this.commonYieldPath(context, this.prepareArgumentsForCall(context, args2, type2), null, null, binding2, type2, block);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        return this.yield(context, value2, null, null, false, binding2, type2);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean isArray, Binding binding2, Block.Type type2) {
        IRubyObject[] args2;
        if (isArray) {
            args2 = this.arity().getValue() > 1 ? (value2 == null ? IRubyObject.NULL_ARRAY : this.prepareArgumentsForYield(context, ((RubyArray)value2).toJavaArray(), type2)) : this.assignArrayToBlockArgs(context.runtime, value2);
        } else {
            IRubyObject[] iRubyObjectArray;
            if (value2 == null) {
                iRubyObjectArray = IRubyObject.NULL_ARRAY;
            } else {
                IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray2;
                iRubyObjectArray2[0] = value2;
            }
            args2 = this.prepareArgumentsForYield(context, iRubyObjectArray, type2);
        }
        return this.commonYieldPath(context, args2, self, klass, binding2, type2, Block.NULL_BLOCK);
    }

    protected IRubyObject prepareSelf(Binding binding2) {
        IRubyObject self = binding2.getSelf();
        binding2.getFrame().setSelf(self);
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject commonYieldPath(ThreadContext context, IRubyObject[] args2, IRubyObject self, RubyModule klass, Binding binding2, Block.Type type2, Block block) {
        Visibility oldVis = binding2.getFrame().getVisibility();
        RubyModule currentModule = this.getStaticScope().getModule();
        Frame prevFrame = context.preYieldNoScope(binding2, klass);
        if (klass == null) {
            self = this.prepareSelf(binding2);
        }
        try {
            DynamicScope prevScope = binding2.getDynamicScope();
            DynamicScope newScope = this.closure.isForLoopBody() ? prevScope : DynamicScope.newDynamicScope(this.getStaticScope(), prevScope);
            context.pushScope(newScope);
            IRubyObject iRubyObject = Interpreter.INTERPRET_BLOCK(context, self, this.closure, args2, binding2.getMethod(), block, type2);
            return iRubyObject;
        }
        finally {
            binding2.getFrame().setVisibility(oldVis);
            context.postYield(binding2, prevFrame);
        }
    }

    protected void blockArgWarning(Ruby ruby2, int length2) {
        ruby2.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length2 + " for 1)");
    }

    private IRubyObject prepareArrayArgsForCall(Ruby ruby2, IRubyObject value2) {
        int length2 = value2 instanceof RubyArray ? ((RubyArray)value2).getLength() : 0;
        switch (length2) {
            case 0: {
                return ruby2.getNil();
            }
            case 1: {
                return ((RubyArray)value2).eltInternal(0);
            }
        }
        this.blockArgWarning(ruby2, length2);
        return value2;
    }

    private IRubyObject[] assignArrayToBlockArgs(Ruby ruby2, IRubyObject value2) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: 
            case 3: {
                IRubyObject[] iRubyObjectArray;
                if (value2 == null) {
                    iRubyObjectArray = IRubyObject.NULL_ARRAY;
                } else if (value2 instanceof RubyArray) {
                    iRubyObjectArray = ((RubyArray)value2).toJavaArrayMaybeUnsafe();
                } else {
                    IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                    iRubyObjectArray = iRubyObjectArray2;
                    iRubyObjectArray2[0] = value2;
                }
                return iRubyObjectArray;
            }
        }
        return new IRubyObject[]{this.prepareArrayArgsForCall(ruby2, value2)};
    }

    protected IRubyObject[] convertToRubyArray(ThreadContext context, IRubyObject[] args2) {
        IRubyObject[] iRubyObjectArray;
        if (args2.length == 0) {
            iRubyObjectArray = context.runtime.getSingleNilArray();
        } else {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = context.runtime.newArrayNoCopy(args2);
        }
        return iRubyObjectArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IRubyObject[] prepareArgumentsForYield(ThreadContext context, IRubyObject[] args2, Block.Type type2) {
        int blockArity = this.arity().getValue();
        if (args2.length == 1) {
            IRubyObject soleArg = args2[0];
            if (soleArg instanceof RubyArray) {
                if (this.argumentType != 1) return args2;
                return ((RubyArray)soleArg).toJavaArray();
            }
            if (blockArity <= 1) return args2;
            IRubyObject toAryArg = RuntimeHelpers.aryToAry(soleArg);
            if (!(toAryArg instanceof RubyArray)) throw context.runtime.newTypeError(soleArg.getType().getName() + "#to_ary should return Array");
            return ((RubyArray)toAryArg).toJavaArray();
        }
        if (this.argumentType != 2) return args2;
        return this.convertToRubyArray(context, args2);
    }

    @Override
    public IRubyObject[] prepareArgumentsForCall(ThreadContext context, IRubyObject[] args2, Block.Type type2) {
        int blockArity = this.arity().getValue();
        switch (type2) {
            case NORMAL: 
            case PROC: {
                if (args2.length == 1) {
                    IRubyObject soleArg = args2[0];
                    if (soleArg instanceof RubyArray) {
                        if (this.argumentType != 1 && (this.argumentType != 3 || type2 != Block.Type.NORMAL)) break;
                        args2 = ((RubyArray)soleArg).toJavaArray();
                        break;
                    }
                    if (blockArity <= 1) break;
                    IRubyObject toAryArg = RuntimeHelpers.aryToAry(soleArg);
                    if (toAryArg instanceof RubyArray) {
                        args2 = ((RubyArray)toAryArg).toJavaArray();
                        break;
                    }
                    throw context.runtime.newTypeError(soleArg.getType().getName() + "#to_ary should return Array");
                }
                if (this.argumentType != 2) break;
                args2 = this.convertToRubyArray(context, args2);
                break;
            }
            case LAMBDA: {
                if (this.argumentType == 2 && args2.length != 1) {
                    if (blockArity != args2.length) {
                        context.runtime.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + args2.length + " for " + blockArity + ")");
                    }
                    args2 = this.convertToRubyArray(context, args2);
                    break;
                }
                this.arity().checkArity(context.runtime, args2);
            }
        }
        return args2;
    }

    @Override
    public String getFile() {
        return this.closure.getFileName();
    }

    @Override
    public int getLine() {
        return this.closure.getLineNumber();
    }
}

