/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Zlib::ZStream"})
public abstract class ZStream
extends RubyObject {
    protected boolean closed = false;

    protected abstract int internalTotalIn();

    protected abstract int internalTotalOut();

    protected abstract boolean internalStreamEndP();

    protected abstract void internalReset();

    protected abstract boolean internalFinished();

    protected abstract long internalAdler();

    protected abstract IRubyObject internalFinish();

    protected abstract void internalClose();

    public ZStream(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block unusedBlock) {
        return this;
    }

    @JRubyMethod
    public IRubyObject flush_next_out(ThreadContext context) {
        return RubyString.newEmptyString(context.getRuntime());
    }

    @JRubyMethod
    public IRubyObject total_out() {
        this.checkClosed();
        return this.getRuntime().newFixnum(this.internalTotalOut());
    }

    @JRubyMethod(name={"stream_end?"})
    public IRubyObject stream_end_p() {
        return this.internalStreamEndP() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"data_type"})
    public IRubyObject data_type() {
        this.checkClosed();
        return this.getRuntime().getModule("Zlib").getConstant("UNKNOWN");
    }

    @JRubyMethod(name={"closed?", "ended?"})
    public IRubyObject closed_p() {
        return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"reset"})
    public IRubyObject reset() {
        this.checkClosed();
        this.internalReset();
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"avail_out"})
    public IRubyObject avail_out() {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"avail_out="}, required=1)
    public IRubyObject set_avail_out(IRubyObject p1) {
        this.checkClosed();
        return p1;
    }

    @JRubyMethod(name={"adler"})
    public IRubyObject adler() {
        this.checkClosed();
        return this.getRuntime().newFixnum(this.internalAdler());
    }

    @JRubyMethod(name={"finish"})
    public IRubyObject finish(ThreadContext context) {
        this.checkClosed();
        IRubyObject result2 = this.internalFinish();
        return result2;
    }

    @JRubyMethod(name={"avail_in"})
    public IRubyObject avail_in() {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"flush_next_in"})
    public IRubyObject flush_next_in(ThreadContext context) {
        return RubyString.newEmptyString(context.getRuntime());
    }

    @JRubyMethod(name={"total_in"})
    public IRubyObject total_in() {
        this.checkClosed();
        return this.getRuntime().newFixnum(this.internalTotalIn());
    }

    @JRubyMethod(name={"finished?"})
    public IRubyObject finished_p(ThreadContext context) {
        this.checkClosed();
        Ruby runtime = context.getRuntime();
        return this.internalFinished() ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(name={"close", "end"})
    public IRubyObject close() {
        this.checkClosed();
        this.internalClose();
        this.closed = true;
        return this.getRuntime().getNil();
    }

    void checkClosed() {
        if (this.closed) {
            throw RubyZlib.newZlibError(this.getRuntime(), "stream is not ready");
        }
    }

    static void checkLevel(Ruby runtime, int level2) {
        if ((level2 < 0 || level2 > 9) && level2 != -1) {
            throw RubyZlib.newStreamError(runtime, "stream error: invalid level");
        }
    }

    static void checkWindowBits(Ruby runtime, int wbits, boolean forInflate) {
        if (((wbits = Math.abs(wbits)) & 0xF) < 8) {
            throw RubyZlib.newStreamError(runtime, "stream error: invalid window bits");
        }
        if ((wbits & 0xF) != 15) {
            runtime.getWarnings().warn("windowBits < 15 is ignored on this platform");
        }
        if (forInflate && wbits > 47) {
            throw RubyZlib.newStreamError(runtime, "stream error: invalid window bits");
        }
        if (!forInflate && wbits > 31) {
            throw RubyZlib.newStreamError(runtime, "stream error: invalid window bits");
        }
    }

    static void checkStrategy(Ruby runtime, int strategy) {
        switch (strategy) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw RubyZlib.newStreamError(runtime, "stream error: invalid strategy");
            }
        }
    }
}

