/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Function;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ext.ffi.jffi.JITMethodGenerator;
import org.jruby.ext.ffi.jffi.JITNativeInvoker;
import org.jruby.ext.ffi.jffi.JITSignature;
import org.jruby.ext.ffi.jffi.NativeInvoker;
import org.jruby.ext.ffi.jffi.Signature;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.ClassWriter;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;

final class AsmClassBuilder {
    public static final boolean DEBUG = Options.FFI_COMPILE_DUMP.load() != false || Options.COMPILE_DUMP.load() != false;
    private static final AtomicLong nextClassID = new AtomicLong(0L);
    private final JITSignature signature;
    private final ClassWriter classWriter;
    private final ClassVisitor classVisitor;
    private final String className;
    private final Class parentClass;
    private final JITMethodGenerator generator;

    AsmClassBuilder(JITMethodGenerator generator, JITSignature signature) {
        this.generator = generator;
        this.signature = signature;
        switch (signature.getParameterCount()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.parentClass = JITNativeInvoker.class;
                break;
            }
            default: {
                throw new UnsupportedOperationException("arity " + signature.getParameterCount() + " not supported");
            }
        }
        this.className = CodegenUtils.p(NativeInvoker.class) + "$ffi$" + nextClassID.getAndIncrement();
        this.classWriter = new ClassWriter(2);
        this.classVisitor = DEBUG ? AsmClassBuilder.newCheckClassAdapter(this.classWriter) : this.classWriter;
        this.classVisitor.visit(49, 17, this.className, null, CodegenUtils.p(this.parentClass), new String[0]);
    }

    Class<? extends NativeInvoker> build() {
        SkinnyMethodAdapter init = new SkinnyMethodAdapter(this.classVisitor, 1, "<init>", CodegenUtils.sig(Void.TYPE, RubyModule.class, Function.class, Signature.class), null, null);
        init.start();
        init.aload(0);
        init.aload(1);
        init.aload(2);
        init.aload(3);
        init.invokespecial(CodegenUtils.p(this.parentClass), "<init>", CodegenUtils.sig(Void.TYPE, RubyModule.class, Function.class, Signature.class));
        init.voidreturn();
        init.visitMaxs(10, 10);
        init.visitEnd();
        this.generator.generate(this, "call", this.signature);
        this.classVisitor.visitEnd();
        try {
            byte[] bytes2 = this.classWriter.toByteArray();
            if (DEBUG) {
                ClassVisitor trace = AsmClassBuilder.newTraceClassVisitor(new PrintWriter(System.err));
                new ClassReader(bytes2).accept(trace, 0);
            }
            JITClassLoader loader = new JITClassLoader(this.getClass().getClassLoader());
            return loader.defineClass(CodegenUtils.c(this.className), bytes2);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ClassVisitor newCheckClassAdapter(ClassVisitor cv) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.jruby.org.objectweb.asm.util.CheckClassAdapter").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(ClassVisitor.class);
            return c.newInstance(cv);
        }
        catch (Throwable t) {
            return cv;
        }
    }

    public static final ClassVisitor newTraceClassVisitor(PrintWriter out) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.jruby.org.objectweb.asm.util.TraceClassVisitor").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(PrintWriter.class);
            return c.newInstance(out);
        }
        catch (Throwable t) {
            return null;
        }
    }

    final String getFunctionFieldName() {
        return "function";
    }

    final String getResultConverterFieldName() {
        return "resultConverter";
    }

    final String getParameterConverterFieldName(int i2) {
        return "parameterConverter" + i2;
    }

    final String getFallbackInvokerFieldName() {
        return "fallbackInvoker";
    }

    final ClassVisitor getClassVisitor() {
        return this.classVisitor;
    }

    final String getClassName() {
        return this.className;
    }

    static final class JITClassLoader
    extends ClassLoader {
        public JITClassLoader() {
        }

        public JITClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(String name2, byte[] b) {
            Class<?> klass = this.defineClass(name2, b, 0, b.length);
            this.resolveClass(klass);
            return klass;
        }
    }
}

