/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.ScanEnvironment;
import org.joni.ast.Node;
import org.joni.ast.StateNode;
import org.joni.ast.StringNode;
import org.joni.constants.Reduce;

public final class QuantifierNode
extends StateNode {
    public Node target;
    public int lower;
    public int upper;
    public boolean greedy;
    public int targetEmptyInfo;
    public Node headExact;
    public Node nextHeadExact;
    public boolean isRefered;
    public int combExpCheckNum;
    public static final int REPEAT_INFINITE = -1;

    public QuantifierNode(int lower, int upper, boolean byNumber) {
        this.lower = lower;
        this.upper = upper;
        this.greedy = true;
        this.targetEmptyInfo = 0;
        if (byNumber) {
            this.setByNumber();
        }
    }

    public int getType() {
        return 5;
    }

    protected void setChild(Node newChild) {
        this.target = newChild;
    }

    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node tgt) {
        this.target = tgt;
        tgt.parent = this;
    }

    public StringNode convertToString(int flag) {
        StringNode sn = new StringNode();
        sn.flag = flag;
        sn.swap(this);
        return sn;
    }

    public String getName() {
        return "Quantifier";
    }

    public String toString(int level2) {
        StringBuilder value2 = new StringBuilder(super.toString(level2));
        value2.append("\n  target: " + QuantifierNode.pad(this.target, level2 + 1));
        value2.append("\n  lower: " + this.lower);
        value2.append("\n  upper: " + this.upper);
        value2.append("\n  greedy: " + this.greedy);
        value2.append("\n  targetEmptyInfo: " + this.targetEmptyInfo);
        value2.append("\n  headExact: " + QuantifierNode.pad(this.headExact, level2 + 1));
        value2.append("\n  nextHeadExact: " + QuantifierNode.pad(this.nextHeadExact, level2 + 1));
        value2.append("\n  isRefered: " + this.isRefered);
        value2.append("\n  combExpCheckNum: " + this.combExpCheckNum);
        return value2.toString();
    }

    public boolean isAnyCharStar() {
        return this.greedy && QuantifierNode.isRepeatInfinite(this.upper) && this.target.getType() == 3;
    }

    protected int popularNum() {
        if (this.greedy) {
            if (this.lower == 0) {
                if (this.upper == 1) {
                    return 0;
                }
                if (QuantifierNode.isRepeatInfinite(this.upper)) {
                    return 1;
                }
            } else if (this.lower == 1 && QuantifierNode.isRepeatInfinite(this.upper)) {
                return 2;
            }
        } else if (this.lower == 0) {
            if (this.upper == 1) {
                return 3;
            }
            if (QuantifierNode.isRepeatInfinite(this.upper)) {
                return 4;
            }
        } else if (this.lower == 1 && QuantifierNode.isRepeatInfinite(this.upper)) {
            return 5;
        }
        return -1;
    }

    protected void set(QuantifierNode other) {
        this.setTarget(other.target);
        other.target = null;
        this.lower = other.lower;
        this.upper = other.upper;
        this.greedy = other.greedy;
        this.targetEmptyInfo = other.targetEmptyInfo;
        this.headExact = other.headExact;
        this.nextHeadExact = other.nextHeadExact;
        this.isRefered = other.isRefered;
        this.combExpCheckNum = other.combExpCheckNum;
    }

    public void reduceNestedQuantifier(QuantifierNode other) {
        int pnum = this.popularNum();
        int cnum = other.popularNum();
        if (pnum < 0 || cnum < 0) {
            return;
        }
        switch (Reduce.REDUCE_TABLE[cnum][pnum]) {
            case DEL: {
                this.set(other);
                break;
            }
            case A: {
                this.setTarget(other.target);
                this.lower = 0;
                this.upper = -1;
                this.greedy = true;
                break;
            }
            case AQ: {
                this.setTarget(other.target);
                this.lower = 0;
                this.upper = -1;
                this.greedy = false;
                break;
            }
            case QQ: {
                this.setTarget(other.target);
                this.lower = 0;
                this.upper = 1;
                this.greedy = false;
                break;
            }
            case P_QQ: {
                this.setTarget(other);
                this.lower = 0;
                this.upper = 1;
                this.greedy = false;
                other.lower = 1;
                other.upper = -1;
                other.greedy = true;
                return;
            }
            case PQ_Q: {
                this.setTarget(other);
                this.lower = 0;
                this.upper = 1;
                this.greedy = true;
                other.lower = 1;
                other.upper = -1;
                other.greedy = false;
                return;
            }
            case ASIS: {
                this.setTarget(other);
                return;
            }
        }
        other.target = null;
    }

    public int setQuantifier(Node tgt, boolean group2, ScanEnvironment env, byte[] bytes2, int p2, int end2) {
        if (this.lower == 1 && this.upper == 1) {
            return 1;
        }
        switch (tgt.getType()) {
            case 0: {
                StringNode n;
                StringNode sn;
                if (group2 || !(sn = (StringNode)tgt).canBeSplit(env.enc) || (n = sn.splitLastChar(env.enc)) == null) break;
                this.setTarget(n);
                return 2;
            }
            case 5: {
                QuantifierNode qnt = (QuantifierNode)tgt;
                int nestQNum = this.popularNum();
                int targetQNum = qnt.popularNum();
                if (targetQNum < 0) break;
                if (nestQNum >= 0) {
                    this.reduceNestedQuantifier(qnt);
                    return 0;
                }
                if (targetQNum != 1 && targetQNum != 2 || QuantifierNode.isRepeatInfinite(this.upper) || this.upper <= 1 || !this.greedy) break;
                this.upper = this.lower == 0 ? 1 : this.lower;
            }
        }
        this.setTarget(tgt);
        return 0;
    }

    public static boolean isRepeatInfinite(int n) {
        return n == -1;
    }
}

