/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;

public abstract class GetInstr
extends Instr
implements ResultInstr {
    private Operand source;
    private String ref;
    private Variable result;

    public GetInstr(Operation op, Variable result2, Operand source2, String ref) {
        super(op);
        assert (result2 != null) : "" + this.getClass().getSimpleName() + " result is null";
        this.source = source2;
        this.ref = ref;
        this.result = result2;
    }

    public String getRef() {
        return this.ref;
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.source};
    }

    public Operand getSource() {
        return this.source;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.source + (this.ref == null ? "" : ", " + this.ref) + ")";
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.source = this.source.getSimplifiedOperand(valueMap, force);
    }
}

