/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class TemporaryVariable
extends Variable {
    public final int offset;
    String name;

    public TemporaryVariable(int offset2) {
        this.offset = offset2;
        this.name = this.getPrefix() + offset2;
    }

    public TemporaryVariable(String name2, int offset2) {
        this.offset = offset2;
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TemporaryVariable)) {
            return false;
        }
        return this.name.equals(((TemporaryVariable)obj).name);
    }

    public int compareTo(Object other) {
        if (!(other instanceof TemporaryVariable)) {
            return 0;
        }
        return this.name.compareTo(((TemporaryVariable)other).name);
    }

    protected String getPrefix() {
        return "%v_";
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Variable cloneForCloningClosure(InlinerInfo ii) {
        return new TemporaryVariable(this.name, this.offset);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, Object[] temp) {
        Object o = temp[this.offset];
        return o == null ? context.nil : o;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.TemporaryVariable(this);
    }
}

