/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashSet;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.ISO8859_1Encoding;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class CharsetTranscoder {
    private static Set<String> BAD_TRANSCODINGS_HACK = new HashSet<String>(){
        {
            this.add("ISO-2022-JP-2");
            this.add("CP50220");
            this.add("CP50221");
        }
    };
    private Encoding toEncoding;
    private CodingErrorActions actions;
    private Encoding forceEncoding = null;

    public CharsetTranscoder(ThreadContext context, Encoding toEncoding, IRubyObject options2) {
        this(context, toEncoding, null, CharsetTranscoder.getCodingErrorActions(context, options2));
    }

    public CharsetTranscoder(ThreadContext context, Encoding toEncoding, Encoding forceEncoding, CodingErrorActions actions) {
        this.toEncoding = toEncoding;
        this.forceEncoding = forceEncoding;
        this.actions = actions == null ? CharsetTranscoder.getCodingErrorActions(context, null) : actions;
    }

    public ByteList transcode(ThreadContext context, ByteList value2) {
        Encoding fromEncoding = this.forceEncoding != null ? this.forceEncoding : value2.getEncoding();
        return this.transcode(context.runtime, value2, fromEncoding);
    }

    protected ByteList transcode(Ruby runtime, ByteList value2, Encoding fromEncoding) {
        Encoding encoding2 = this.toEncoding != null ? this.toEncoding : value2.getEncoding();
        String toName = encoding2.toString();
        String fromName = fromEncoding.toString();
        Charset from = CharsetTranscoder.transcodeCharsetFor(runtime, fromEncoding, fromName, toName);
        Charset to = CharsetTranscoder.transcodeCharsetFor(runtime, encoding2, fromName, toName);
        CharsetEncoder encoder = this.getCharsetEncoder(to);
        CharsetDecoder decoder = this.getCharsetDecoder(from);
        ByteBuffer fromBytes = ByteBuffer.wrap(value2.getUnsafeBytes(), value2.begin(), value2.length());
        try {
            ByteBuffer toBytes = encoder.encode(decoder.decode(fromBytes));
            return new ByteList(toBytes.array(), toBytes.arrayOffset(), toBytes.limit() - toBytes.arrayOffset(), encoding2, false);
        }
        catch (CharacterCodingException e) {
            throw runtime.newUndefinedConversionError(e.getLocalizedMessage());
        }
    }

    public static ByteList transcode(ThreadContext context, ByteList value2, Encoding forceEncoding, Encoding toEncoding, IRubyObject opts) {
        if (toEncoding == null) {
            return value2;
        }
        return new CharsetTranscoder(context, toEncoding, forceEncoding, CharsetTranscoder.getCodingErrorActions(context, opts)).transcode(context, value2);
    }

    public static CodingErrorActions getCodingErrorActions(ThreadContext context, IRubyObject opts) {
        IRubyObject undef;
        IRubyObject invalid;
        RubyString replaceWithStr;
        if (opts == null || opts.isNil()) {
            return new CodingErrorActions(CodingErrorAction.REPORT, CodingErrorAction.REPORT, null);
        }
        Ruby runtime = context.runtime;
        RubyHash hash2 = (RubyHash)opts;
        CodingErrorAction onMalformedInput = CodingErrorAction.REPORT;
        CodingErrorAction onUnmappableCharacter = CodingErrorAction.REPORT;
        RubyString replaceWith = null;
        IRubyObject replace2 = hash2.fastARef(runtime.newSymbol("replace"));
        if (replace2 != null && !replace2.isNil() && (replaceWithStr = replace2.convertToString()).size() == 1) {
            replaceWith = replaceWithStr;
        }
        if ((invalid = hash2.fastARef(runtime.newSymbol("invalid"))) != null && invalid.op_equal(context, runtime.newSymbol("replace")).isTrue()) {
            onMalformedInput = CodingErrorAction.REPLACE;
        }
        if ((undef = hash2.fastARef(runtime.newSymbol("undef"))) != null && undef.op_equal(context, runtime.newSymbol("replace")).isTrue()) {
            onUnmappableCharacter = CodingErrorAction.REPLACE;
        }
        if (replaceWith == null && (onUnmappableCharacter == CodingErrorAction.REPLACE || onMalformedInput == CodingErrorAction.REPLACE)) {
            replaceWith = context.runtime.newString("?");
        }
        return new CodingErrorActions(onUnmappableCharacter, onMalformedInput, replaceWith);
    }

    private CharsetDecoder getCharsetDecoder(Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onUnmappableCharacter(this.actions.onUnmappableCharacter);
        decoder.onMalformedInput(this.actions.onMalformedInput);
        if (this.actions.replaceWith != null) {
            decoder.replaceWith(this.actions.replaceWith.toString());
        }
        return decoder;
    }

    private CharsetEncoder getCharsetEncoder(Charset charset) {
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onUnmappableCharacter(this.actions.onUnmappableCharacter);
        encoder.onMalformedInput(this.actions.onMalformedInput);
        if (this.actions.replaceWith != null) {
            encoder.replaceWith(this.actions.replaceWith.getBytes());
        }
        return encoder;
    }

    private static Charset transcodeCharsetFor(Ruby runtime, Encoding encoding2, String fromName, String toName) {
        if (encoding2 == ASCIIEncoding.INSTANCE) {
            return ISO8859_1Encoding.INSTANCE.getCharset();
        }
        Charset from = null;
        String realEncodingName = new String(encoding2.getName());
        if (!realEncodingName.equals(encoding2.getCharsetName()) && !BAD_TRANSCODINGS_HACK.contains(realEncodingName)) {
            try {
                from = Charset.forName(realEncodingName);
                if (from != null) {
                    return from;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            from = encoding2.getCharset();
            if (from != null && encoding2.getCharsetName() != null && from.name().equals(encoding2.getCharsetName())) {
                return from;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            from = Charset.forName(encoding2.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (from == null) {
            throw runtime.newConverterNotFoundError("code converter not found (" + fromName + " to " + toName + ")");
        }
        return from;
    }

    public static class CodingErrorActions {
        final CodingErrorAction onUnmappableCharacter;
        final CodingErrorAction onMalformedInput;
        final RubyString replaceWith;

        CodingErrorActions(CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput, RubyString replaceWith) {
            this.onUnmappableCharacter = onUnmappableCharacter;
            this.onMalformedInput = onMalformedInput;
            this.replaceWith = replaceWith;
        }

        public String toString() {
            return "UnmappableCharacter: " + this.onUnmappableCharacter + ", MalformedInput: " + this.onMalformedInput + ", replaceWith: " + this.replaceWith;
        }
    }
}

