/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.callback;

import java.lang.reflect.Member;
import org.jruby.Ruby;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public abstract class InvocationCallback
implements Callback {
    public static final Class[] EMPTY_ARGS = new Class[0];
    public static final Class[] OPTIONAL_ARGS = new Class[]{IRubyObject[].class};
    protected int arityValue;
    protected Arity arity;
    private Class[] argumentTypes = EMPTY_ARGS;
    private String javaName;
    private boolean isSingleton;
    private Member target;

    public IRubyObject execute(IRubyObject recv2, IRubyObject[] oargs, Block block) {
        if (this.arityValue >= 0) {
            if (oargs.length != this.arityValue) {
                throw recv2.getRuntime().newArgumentError("wrong number of arguments (" + oargs.length + " for " + this.arityValue + ")");
            }
        } else if (oargs.length < -(1 + this.arityValue)) {
            throw recv2.getRuntime().newArgumentError("wrong number of arguments (" + oargs.length + " for " + -(1 + this.arityValue) + ")");
        }
        try {
            return this.call(recv2, oargs, block);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (JumpException e) {
            throw e;
        }
        catch (ThreadKill e) {
            throw e;
        }
        catch (MainExitException e) {
            throw e;
        }
        catch (Exception e) {
            Ruby runtime = recv2.getRuntime();
            runtime.getJavaSupport().handleNativeException(e, this.getTarget());
            return runtime.getNil();
        }
    }

    public abstract IRubyObject call(Object var1, Object[] var2, Block var3);

    public void setArity(Arity arity2) {
        this.arity = arity2;
        this.arityValue = arity2.getValue();
    }

    public Arity getArity() {
        return this.arity;
    }

    public void setArgumentTypes(Class[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public Class[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public void setTarget(Member target) {
        this.target = target;
    }

    public Member getTarget() {
        return this.target;
    }
}

