/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.util.test;

import java.io.PrintStream;
import org.jruby.org.bouncycastle.util.Arrays;
import org.jruby.org.bouncycastle.util.test.SimpleTestResult;
import org.jruby.org.bouncycastle.util.test.Test;
import org.jruby.org.bouncycastle.util.test.TestFailedException;
import org.jruby.org.bouncycastle.util.test.TestResult;

public abstract class SimpleTest
implements Test {
    public abstract String getName();

    private TestResult success() {
        return SimpleTestResult.successful(this, "Okay");
    }

    protected void fail(String string2) {
        throw new TestFailedException(SimpleTestResult.failed(this, string2));
    }

    protected void fail(String string2, Throwable throwable) {
        throw new TestFailedException(SimpleTestResult.failed(this, string2, throwable));
    }

    protected void fail(String string2, Object object, Object object2) {
        throw new TestFailedException(SimpleTestResult.failed(this, string2, object, object2));
    }

    protected boolean areEqual(byte[] byArray, byte[] byArray2) {
        return Arrays.areEqual(byArray, byArray2);
    }

    public TestResult perform() {
        try {
            this.performTest();
            return this.success();
        }
        catch (TestFailedException testFailedException) {
            return testFailedException.getResult();
        }
        catch (Exception exception2) {
            return SimpleTestResult.failed(this, "Exception: " + exception2, exception2);
        }
    }

    protected static void runTest(Test test2) {
        SimpleTest.runTest(test2, System.out);
    }

    protected static void runTest(Test test2, PrintStream printStream) {
        TestResult testResult = test2.perform();
        printStream.println(((Object)testResult).toString());
        if (testResult.getException() != null) {
            testResult.getException().printStackTrace(printStream);
        }
    }

    public abstract void performTest() throws Exception;
}

