/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.ASN1Set;
import org.jruby.org.bouncycastle.asn1.pkcs.Attribute;
import org.jruby.org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.jruby.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.jruby.org.bouncycastle.asn1.x500.X500Name;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.operator.ContentVerifier;
import org.jruby.org.bouncycastle.operator.ContentVerifierProvider;
import org.jruby.org.bouncycastle.pkcs.PKCSException;
import org.jruby.org.bouncycastle.pkcs.PKCSIOException;

public class PKCS10CertificationRequestHolder {
    private static Attribute[] EMPTY_ARRAY = new Attribute[0];
    private CertificationRequest certificationRequest;

    private static CertificationRequest parseBytes(byte[] byArray) throws IOException {
        try {
            return CertificationRequest.getInstance(ASN1Object.fromByteArray(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new PKCSIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PKCSIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public PKCS10CertificationRequestHolder(CertificationRequest certificationRequest) {
        this.certificationRequest = certificationRequest;
    }

    public PKCS10CertificationRequestHolder(byte[] byArray) throws IOException {
        this(PKCS10CertificationRequestHolder.parseBytes(byArray));
    }

    public CertificationRequest toASN1Structure() {
        return this.certificationRequest;
    }

    public X500Name getSubject() {
        return X500Name.getInstance(this.certificationRequest.getCertificationRequestInfo().getSubject());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.certificationRequest.getSignatureAlgorithm();
    }

    public byte[] getSignature() {
        return this.certificationRequest.getSignature().getBytes();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.certificationRequest.getCertificationRequestInfo().getSubjectPublicKeyInfo();
    }

    public Attribute[] getAttributes() {
        ASN1Set aSN1Set = this.certificationRequest.getCertificationRequestInfo().getAttributes();
        if (aSN1Set == null) {
            return EMPTY_ARRAY;
        }
        Attribute[] attributeArray = new Attribute[aSN1Set.size()];
        for (int j = 0; j != aSN1Set.size(); ++j) {
            attributeArray[j] = Attribute.getInstance(aSN1Set.getObjectAt(j));
        }
        return attributeArray;
    }

    public Attribute[] getAttributes(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        ASN1Set aSN1Set = this.certificationRequest.getCertificationRequestInfo().getAttributes();
        if (aSN1Set == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int j = 0; j != aSN1Set.size(); ++j) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(j));
            if (!attribute.getAttrType().equals(aSN1ObjectIdentifier)) continue;
            arrayList.add(attribute);
        }
        if (arrayList.size() == 0) {
            return EMPTY_ARRAY;
        }
        return arrayList.toArray(new Attribute[arrayList.size()]);
    }

    public byte[] getEncoded() throws IOException {
        return this.certificationRequest.getEncoded();
    }

    public boolean isSignatureValid(ContentVerifierProvider contentVerifierProvider) throws PKCSException {
        ContentVerifier contentVerifier;
        CertificationRequestInfo certificationRequestInfo = this.certificationRequest.getCertificationRequestInfo();
        try {
            contentVerifier = contentVerifierProvider.get(this.certificationRequest.getSignatureAlgorithm());
            OutputStream outputStream = contentVerifier.getOutputStream();
            outputStream.write(certificationRequestInfo.getDEREncoded());
            outputStream.close();
        }
        catch (Exception exception2) {
            throw new PKCSException("unable to process signature: " + exception2.getMessage(), exception2);
        }
        return contentVerifier.verify(this.certificationRequest.getSignature().getBytes());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PKCS10CertificationRequestHolder)) {
            return false;
        }
        PKCS10CertificationRequestHolder pKCS10CertificationRequestHolder = (PKCS10CertificationRequestHolder)object;
        return this.toASN1Structure().equals(pKCS10CertificationRequestHolder.toASN1Structure());
    }

    public int hashCode() {
        return this.toASN1Structure().hashCode();
    }
}

