/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.operator.bc;

import org.jruby.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.crypto.Digest;
import org.jruby.org.bouncycastle.crypto.ExtendedDigest;
import org.jruby.org.bouncycastle.crypto.digests.MD4Digest;
import org.jruby.org.bouncycastle.crypto.digests.MD5Digest;
import org.jruby.org.bouncycastle.crypto.digests.SHA1Digest;
import org.jruby.org.bouncycastle.crypto.digests.SHA224Digest;
import org.jruby.org.bouncycastle.crypto.digests.SHA256Digest;
import org.jruby.org.bouncycastle.crypto.digests.SHA384Digest;
import org.jruby.org.bouncycastle.operator.OperatorCreationException;

class BcUtil {
    BcUtil() {
    }

    static Digest createDigest(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        ExtendedDigest extendedDigest;
        if (algorithmIdentifier.getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
            extendedDigest = new SHA1Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
            extendedDigest = new SHA224Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
            extendedDigest = new SHA256Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha384)) {
            extendedDigest = new SHA384Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha512)) {
            extendedDigest = new SHA384Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.md5)) {
            extendedDigest = new MD5Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.md4)) {
            extendedDigest = new MD4Digest();
        } else {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return extendedDigest;
    }
}

