/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.jruby.org.bouncycastle.asn1.ASN1InputStream;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DEREnumerated;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.util.ASN1Dump;
import org.jruby.org.bouncycastle.asn1.x509.CRLReason;
import org.jruby.org.bouncycastle.asn1.x509.GeneralName;
import org.jruby.org.bouncycastle.asn1.x509.GeneralNames;
import org.jruby.org.bouncycastle.asn1.x509.TBSCertList;
import org.jruby.org.bouncycastle.asn1.x509.X509Extension;
import org.jruby.org.bouncycastle.asn1.x509.X509Extensions;
import org.jruby.org.bouncycastle.x509.extension.X509ExtensionUtil;

public class X509CRLEntryObject
extends X509CRLEntry {
    private TBSCertList.CRLEntry c;
    private boolean isIndirect;
    private X500Principal previousCertificateIssuer;
    private X500Principal certificateIssuer;
    private int hashValue;
    private boolean isHashValueSet;

    public X509CRLEntryObject(TBSCertList.CRLEntry cRLEntry) {
        this.c = cRLEntry;
        this.certificateIssuer = this.loadCertificateIssuer();
    }

    public X509CRLEntryObject(TBSCertList.CRLEntry cRLEntry, boolean bl, X500Principal x500Principal) {
        this.c = cRLEntry;
        this.isIndirect = bl;
        this.previousCertificateIssuer = x500Principal;
        this.certificateIssuer = this.loadCertificateIssuer();
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        return set != null && !set.isEmpty();
    }

    private X500Principal loadCertificateIssuer() {
        if (!this.isIndirect) {
            return null;
        }
        byte[] byArray = this.getExtensionValue(X509Extensions.CertificateIssuer.getId());
        if (byArray == null) {
            return this.previousCertificateIssuer;
        }
        try {
            GeneralName[] generalNameArray = GeneralNames.getInstance(X509ExtensionUtil.fromExtensionValue(byArray)).getNames();
            for (int j = 0; j < generalNameArray.length; ++j) {
                if (generalNameArray[j].getTagNo() != 4) continue;
                return new X500Principal(generalNameArray[j].getName().getDERObject().getDEREncoded());
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public X500Principal getCertificateIssuer() {
        return this.certificateIssuer;
    }

    private Set getExtensionOIDs(boolean bl) {
        X509Extensions x509Extensions = this.c.getExtensions();
        if (x509Extensions != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (bl != x509Extension.isCritical()) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String string2) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.c.getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string2))) != null) {
            try {
                return x509Extension.getValue().getEncoded();
            }
            catch (Exception exception2) {
                throw new RuntimeException("error encoding " + exception2.toString());
            }
        }
        return null;
    }

    public int hashCode() {
        if (!this.isHashValueSet) {
            this.hashValue = super.hashCode();
            this.isHashValueSet = true;
        }
        return this.hashValue;
    }

    public byte[] getEncoded() throws CRLException {
        try {
            return this.c.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    public BigInteger getSerialNumber() {
        return this.c.getUserCertificate().getValue();
    }

    public Date getRevocationDate() {
        return this.c.getRevocationDate().getDate();
    }

    public boolean hasExtensions() {
        return this.c.getExtensions() != null;
    }

    public String toString() {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        stringBuffer.append("      userCertificate: ").append(this.getSerialNumber()).append(string2);
        stringBuffer.append("       revocationDate: ").append(this.getRevocationDate()).append(string2);
        stringBuffer.append("       certificateIssuer: ").append(this.getCertificateIssuer()).append(string2);
        X509Extensions x509Extensions = this.c.getExtensions();
        if (x509Extensions != null && (enumeration = x509Extensions.oids()).hasMoreElements()) {
            stringBuffer.append("   crlEntryExtensions:").append(string2);
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (x509Extension.getValue() != null) {
                    byte[] byArray = x509Extension.getValue().getOctets();
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
                    stringBuffer.append("                       critical(").append(x509Extension.isCritical()).append(") ");
                    try {
                        if (dERObjectIdentifier.equals(X509Extensions.ReasonCode)) {
                            stringBuffer.append(new CRLReason(DEREnumerated.getInstance(aSN1InputStream.readObject()))).append(string2);
                            continue;
                        }
                        if (dERObjectIdentifier.equals(X509Extensions.CertificateIssuer)) {
                            stringBuffer.append("Certificate issuer: ").append(new GeneralNames((ASN1Sequence)aSN1InputStream.readObject())).append(string2);
                            continue;
                        }
                        stringBuffer.append(dERObjectIdentifier.getId());
                        stringBuffer.append(" value = ").append(ASN1Dump.dumpAsString(aSN1InputStream.readObject())).append(string2);
                    }
                    catch (Exception exception2) {
                        stringBuffer.append(dERObjectIdentifier.getId());
                        stringBuffer.append(" value = ").append("*****").append(string2);
                    }
                    continue;
                }
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }
}

