/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.jce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.pkcs.DHParameter;
import org.jruby.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.asn1.x9.DHDomainParameters;
import org.jruby.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.jruby.org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class JCEDHPublicKey
implements DHPublicKey {
    static final long serialVersionUID = -216691575254424324L;
    private BigInteger y;
    private DHParameterSpec dhSpec;
    private SubjectPublicKeyInfo info;

    JCEDHPublicKey(DHPublicKeySpec dHPublicKeySpec) {
        this.y = dHPublicKeySpec.getY();
        this.dhSpec = new DHParameterSpec(dHPublicKeySpec.getP(), dHPublicKeySpec.getG());
    }

    JCEDHPublicKey(DHPublicKey dHPublicKey) {
        this.y = dHPublicKey.getY();
        this.dhSpec = dHPublicKey.getParams();
    }

    JCEDHPublicKey(DHPublicKeyParameters dHPublicKeyParameters) {
        this.y = dHPublicKeyParameters.getY();
        this.dhSpec = new DHParameterSpec(dHPublicKeyParameters.getParameters().getP(), dHPublicKeyParameters.getParameters().getG(), dHPublicKeyParameters.getParameters().getL());
    }

    JCEDHPublicKey(BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        this.y = bigInteger;
        this.dhSpec = dHParameterSpec;
    }

    JCEDHPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        DERInteger dERInteger;
        this.info = subjectPublicKeyInfo;
        try {
            dERInteger = (DERInteger)subjectPublicKeyInfo.getPublicKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DH public key");
        }
        this.y = dERInteger.getValue();
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(subjectPublicKeyInfo.getAlgorithmId().getParameters());
        DERObjectIdentifier dERObjectIdentifier = subjectPublicKeyInfo.getAlgorithmId().getObjectId();
        if (dERObjectIdentifier.equals(PKCSObjectIdentifiers.dhKeyAgreement) || this.isPKCSParam(aSN1Sequence)) {
            DHParameter dHParameter = new DHParameter(aSN1Sequence);
            this.dhSpec = dHParameter.getL() != null ? new DHParameterSpec(dHParameter.getP(), dHParameter.getG(), dHParameter.getL().intValue()) : new DHParameterSpec(dHParameter.getP(), dHParameter.getG());
        } else if (dERObjectIdentifier.equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DHDomainParameters dHDomainParameters = DHDomainParameters.getInstance(aSN1Sequence);
            this.dhSpec = new DHParameterSpec(dHDomainParameters.getP().getValue(), dHDomainParameters.getG().getValue());
        } else {
            throw new IllegalArgumentException("unknown algorithm type: " + dERObjectIdentifier);
        }
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        if (this.info != null) {
            return this.info.getDEREncoded();
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, new DHParameter(this.dhSpec.getP(), this.dhSpec.getG(), this.dhSpec.getL()).getDERObject()), new DERInteger(this.y));
        return subjectPublicKeyInfo.getDEREncoded();
    }

    public DHParameterSpec getParams() {
        return this.dhSpec;
    }

    public BigInteger getY() {
        return this.y;
    }

    private boolean isPKCSParam(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            return true;
        }
        if (aSN1Sequence.size() > 3) {
            return false;
        }
        DERInteger dERInteger = DERInteger.getInstance(aSN1Sequence.getObjectAt(2));
        DERInteger dERInteger2 = DERInteger.getInstance(aSN1Sequence.getObjectAt(0));
        return dERInteger.getValue().compareTo(BigInteger.valueOf(dERInteger2.getValue().bitLength())) <= 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.y = (BigInteger)objectInputStream.readObject();
        this.dhSpec = new DHParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)objectInputStream.readObject(), objectInputStream.readInt());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getY());
        objectOutputStream.writeObject(this.dhSpec.getP());
        objectOutputStream.writeObject(this.dhSpec.getG());
        objectOutputStream.writeInt(this.dhSpec.getL());
    }
}

