/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1Set;
import org.jruby.org.bouncycastle.asn1.BERConstructedOctetString;
import org.jruby.org.bouncycastle.asn1.BERSet;
import org.jruby.org.bouncycastle.asn1.DERSet;
import org.jruby.org.bouncycastle.asn1.cms.AttributeTable;
import org.jruby.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.jruby.org.bouncycastle.asn1.cms.ContentInfo;
import org.jruby.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.jruby.org.bouncycastle.asn1.cms.EnvelopedData;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedData;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.jruby.org.bouncycastle.cms.CMSEnvelopedHelper;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.CMSProcessable;
import org.jruby.org.bouncycastle.cms.CMSTypedData;
import org.jruby.org.bouncycastle.cms.CMSUtils;
import org.jruby.org.bouncycastle.operator.GenericKey;
import org.jruby.org.bouncycastle.operator.OutputEncryptor;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    public CMSEnvelopedDataGenerator() {
    }

    public CMSEnvelopedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    private CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string2, KeyGenerator keyGenerator, Provider provider) throws NoSuchAlgorithmException, CMSException {
        BERConstructedOctetString bERConstructedOctetString;
        Object object;
        AlgorithmIdentifier algorithmIdentifier;
        Object object22;
        SecretKey secretKey;
        Object object3;
        Provider provider2 = keyGenerator.getProvider();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            object3 = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(string2, provider2);
            secretKey = keyGenerator.generateKey();
            object22 = this.generateParameters(string2, secretKey, provider2);
            ((Cipher)object3).init(1, (Key)secretKey, (AlgorithmParameters)object22, this.rand);
            if (object22 == null) {
                object22 = ((Cipher)object3).getParameters();
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(string2, (AlgorithmParameters)object22);
            object = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream((OutputStream)object, (Cipher)object3);
            cMSProcessable.write(cipherOutputStream);
            cipherOutputStream.close();
            bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        for (Object object22 : this.oldRecipientInfoGenerators) {
            try {
                aSN1EncodableVector.add(object22.generate(secretKey, this.rand, provider));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        for (Object object22 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add(object22.generate(new GenericKey(secretKey)));
        }
        object3 = cMSProcessable instanceof CMSTypedData ? new EncryptedContentInfo(((CMSTypedData)cMSProcessable).getContentType(), algorithmIdentifier, bERConstructedOctetString) : new EncryptedContentInfo(CMSObjectIdentifiers.data, algorithmIdentifier, bERConstructedOctetString);
        object22 = null;
        if (this.unprotectedAttributeGenerator != null) {
            object = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            object22 = new BERSet(((AttributeTable)object).toASN1EncodableVector());
        }
        object = new ContentInfo(CMSObjectIdentifiers.envelopedData, new EnvelopedData(null, new DERSet(aSN1EncodableVector), (EncryptedContentInfo)object3, (ASN1Set)object22));
        return new CMSEnvelopedData((ContentInfo)object);
    }

    private CMSEnvelopedData doGenerate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        Object object;
        Object object22;
        Object object3;
        if (!this.oldRecipientInfoGenerators.isEmpty()) {
            throw new IllegalStateException("can only use addRecipientGenerator() with this method");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object3 = outputEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object3);
            ((OutputStream)object3).close();
        }
        catch (IOException iOException) {
            throw new CMSException("");
        }
        object3 = byteArrayOutputStream.toByteArray();
        AlgorithmIdentifier algorithmIdentifier = outputEncryptor.getAlgorithmIdentifier();
        BERConstructedOctetString bERConstructedOctetString = new BERConstructedOctetString((byte[])object3);
        GenericKey genericKey = outputEncryptor.getKey();
        for (Object object22 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add(object22.generate(genericKey));
        }
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(cMSTypedData.getContentType(), algorithmIdentifier, bERConstructedOctetString);
        object22 = null;
        if (this.unprotectedAttributeGenerator != null) {
            object = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            object22 = new BERSet(((AttributeTable)object).toASN1EncodableVector());
        }
        object = new ContentInfo(CMSObjectIdentifiers.envelopedData, new EnvelopedData(null, new DERSet(aSN1EncodableVector), encryptedContentInfo, (ASN1Set)object22));
        return new CMSEnvelopedData((ContentInfo)object);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, string2, CMSUtils.getProvider(string3));
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string2, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string2, provider);
        keyGenerator.init(this.rand);
        return this.generate(cMSProcessable, string2, keyGenerator, provider);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string2, int n, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, string2, n, CMSUtils.getProvider(string3));
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string2, int n, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string2, provider);
        keyGenerator.init(n, this.rand);
        return this.generate(cMSProcessable, string2, keyGenerator, provider);
    }

    public CMSEnvelopedData generate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputEncryptor);
    }
}

