/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cert.ocsp;

import java.util.Date;
import org.jruby.org.bouncycastle.asn1.ASN1Sequence;
import org.jruby.org.bouncycastle.asn1.ocsp.ResponseData;
import org.jruby.org.bouncycastle.asn1.ocsp.SingleResponse;
import org.jruby.org.bouncycastle.asn1.x509.X509Extensions;
import org.jruby.org.bouncycastle.cert.ocsp.OCSPUtils;
import org.jruby.org.bouncycastle.cert.ocsp.RespID;
import org.jruby.org.bouncycastle.cert.ocsp.SingleResp;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData responseData) {
        this.data = responseData;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence aSN1Sequence = this.data.getResponses();
        SingleResp[] singleRespArray = new SingleResp[aSN1Sequence.size()];
        for (int j = 0; j != singleRespArray.length; ++j) {
            singleRespArray[j] = new SingleResp(SingleResponse.getInstance(aSN1Sequence.getObjectAt(j)));
        }
        return singleRespArray;
    }

    public X509Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

