/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cert.cmp;

import org.jruby.org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.jruby.org.bouncycastle.asn1.cmp.CertStatus;
import org.jruby.org.bouncycastle.cert.cmp.CertificateStatus;
import org.jruby.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.jruby.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CertificateConfirmationContent {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertConfirmContent content;

    public CertificateConfirmationContent(CertConfirmContent certConfirmContent) {
        this(certConfirmContent, new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContent(CertConfirmContent certConfirmContent, DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.content = certConfirmContent;
    }

    public CertConfirmContent toASN1Structure() {
        return this.content;
    }

    public CertificateStatus[] getStatusMessages() {
        CertStatus[] certStatusArray = this.content.toCertStatusArray();
        CertificateStatus[] certificateStatusArray = new CertificateStatus[certStatusArray.length];
        for (int j = 0; j != certificateStatusArray.length; ++j) {
            certificateStatusArray[j] = new CertificateStatus(this.digestAlgFinder, certStatusArray[j]);
        }
        return certificateStatusArray;
    }
}

