/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cert;

import java.math.BigInteger;
import java.util.Date;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.x500.X500Name;
import org.jruby.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.org.bouncycastle.asn1.x509.Time;
import org.jruby.org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.jruby.org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.jruby.org.bouncycastle.asn1.x509.X509Extension;
import org.jruby.org.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import org.jruby.org.bouncycastle.cert.CertUtils;
import org.jruby.org.bouncycastle.cert.X509CertificateHolder;
import org.jruby.org.bouncycastle.operator.ContentSigner;

public class X509v3CertificateBuilder {
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private X509ExtensionsGenerator extGenerator;

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Date date, Date date2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.tbsGen.setSerialNumber(new DERInteger(bigInteger));
        this.tbsGen.setIssuer(x500Name);
        this.tbsGen.setStartDate(new Time(date));
        this.tbsGen.setEndDate(new Time(date2));
        this.tbsGen.setSubject(x500Name2);
        this.tbsGen.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        this.extGenerator = new X509ExtensionsGenerator();
    }

    public X509v3CertificateBuilder setSubjectUniqueID(boolean[] blArray) {
        this.tbsGen.setSubjectUniqueID(CertUtils.booleanToBitString(blArray));
        return this;
    }

    public X509v3CertificateBuilder setIssuerUniqueID(boolean[] blArray) {
        this.tbsGen.setIssuerUniqueID(CertUtils.booleanToBitString(blArray));
        return this;
    }

    public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1Encodable aSN1Encodable) {
        this.extGenerator.addExtension((DERObjectIdentifier)aSN1ObjectIdentifier, bl, aSN1Encodable);
        return this;
    }

    public X509v3CertificateBuilder copyAndAddExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, X509CertificateHolder x509CertificateHolder) {
        X509CertificateStructure x509CertificateStructure = x509CertificateHolder.toASN1Structure();
        X509Extension x509Extension = x509CertificateStructure.getTBSCertificate().getExtensions().getExtension(aSN1ObjectIdentifier);
        if (x509Extension == null) {
            throw new NullPointerException("extension " + aSN1ObjectIdentifier + " not present");
        }
        this.extGenerator.addExtension((DERObjectIdentifier)aSN1ObjectIdentifier, bl, x509Extension.getValue().getOctets());
        return this;
    }

    public X509CertificateHolder build(ContentSigner contentSigner) {
        this.tbsGen.setSignature(contentSigner.getAlgorithmIdentifier());
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        return CertUtils.generateFullCert(contentSigner, this.tbsGen.generateTBSCertificate());
    }
}

