/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.asn1.cms;

import org.jruby.org.bouncycastle.asn1.ASN1Choice;
import org.jruby.org.bouncycastle.asn1.ASN1Encodable;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.ASN1TaggedObject;
import org.jruby.org.bouncycastle.asn1.DEREncodable;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;

public class SignerIdentifier
extends ASN1Encodable
implements ASN1Choice {
    private DEREncodable id;

    public SignerIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    public SignerIdentifier(ASN1OctetString aSN1OctetString) {
        this.id = new DERTaggedObject(false, 0, aSN1OctetString);
    }

    public SignerIdentifier(DERObject dERObject) {
        this.id = dERObject;
    }

    public static SignerIdentifier getInstance(Object object) {
        if (object == null || object instanceof SignerIdentifier) {
            return (SignerIdentifier)object;
        }
        if (object instanceof IssuerAndSerialNumber) {
            return new SignerIdentifier((IssuerAndSerialNumber)object);
        }
        if (object instanceof ASN1OctetString) {
            return new SignerIdentifier((ASN1OctetString)object);
        }
        if (object instanceof DERObject) {
            return new SignerIdentifier((DERObject)object);
        }
        throw new IllegalArgumentException("Illegal object in SignerIdentifier: " + object.getClass().getName());
    }

    public boolean isTagged() {
        return this.id instanceof ASN1TaggedObject;
    }

    public DEREncodable getId() {
        if (this.id instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance((ASN1TaggedObject)this.id, false);
        }
        return this.id;
    }

    public DERObject toASN1Object() {
        return this.id.getDERObject();
    }
}

