/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Extensions;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.X509Revoked;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.org.bouncycastle.asn1.ASN1EncodableVector;
import org.jruby.org.bouncycastle.asn1.ASN1InputStream;
import org.jruby.org.bouncycastle.asn1.DERBoolean;
import org.jruby.org.bouncycastle.asn1.DEREncodable;
import org.jruby.org.bouncycastle.asn1.DERInteger;
import org.jruby.org.bouncycastle.asn1.DERObject;
import org.jruby.org.bouncycastle.asn1.DERObjectIdentifier;
import org.jruby.org.bouncycastle.asn1.DERSequence;
import org.jruby.org.bouncycastle.asn1.DERTaggedObject;
import org.jruby.org.bouncycastle.asn1.x509.X509Extensions;
import org.jruby.org.bouncycastle.x509.X509V2CRLGenerator;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class X509CRL
extends RubyObject {
    private static final long serialVersionUID = -2463300006179688577L;
    private static ObjectAllocator X509CRL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509CRL(runtime, klass);
        }
    };
    private IRubyObject version;
    private IRubyObject issuer;
    private IRubyObject last_update;
    private IRubyObject next_update;
    private IRubyObject revoked;
    private List<IRubyObject> extensions;
    private IRubyObject sig_alg;
    private boolean changed = true;
    private X509V2CRLGenerator generator = new X509V2CRLGenerator();
    private java.security.cert.X509CRL crl;
    private DERObject crl_v;
    private static final String IND8 = "        ";
    private static final String IND12 = "            ";
    private static final String IND16 = "                ";
    private static final DateFormat ASN_DATE = new SimpleDateFormat("MMM dd HH:mm:ss yyyy zzz");

    public static void createX509CRL(Ruby runtime, RubyModule mX509) {
        RubyClass cX509CRL = mX509.defineClassUnder("CRL", runtime.getObject(), X509CRL_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("CRLError", openSSLError, openSSLError.getAllocator());
        cX509CRL.defineAnnotatedMethods(X509CRL.class);
    }

    java.security.cert.X509CRL getCRL() {
        return this.crl;
    }

    public X509CRL(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true)
    public IRubyObject _initialize(IRubyObject[] args2, Block block) {
        this.extensions = new ArrayList<IRubyObject>();
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 0, 1) == 0) {
            this.version = this.getRuntime().getNil();
            this.issuer = this.getRuntime().getNil();
            this.last_update = this.getRuntime().getNil();
            this.next_update = this.getRuntime().getNil();
            this.revoked = this.getRuntime().newArray();
            return this;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(args2[0].convertToString().getBytes());
        try {
            CertificateFactory cf = OpenSSLReal.getX509CertificateFactoryBC();
            this.crl = (java.security.cert.X509CRL)cf.generateCRL(bis);
        }
        catch (GeneralSecurityException gse) {
            throw X509CRL.newX509CRLError(this.getRuntime(), gse.getMessage());
        }
        byte[] crl_bytes = OpenSSLImpl.readX509PEM(args2[0]);
        try {
            this.crl_v = new ASN1InputStream(new ByteArrayInputStream(crl_bytes)).readObject();
        }
        catch (IOException ioe) {
            throw X509CRL.newX509CRLError(this.getRuntime(), ioe.getMessage());
        }
        DEREncodable v0 = ((DERSequence)((DERSequence)this.crl_v).getObjectAt(0)).getObjectAt(0);
        if (v0 instanceof DERInteger) {
            this.set_version(this.getRuntime().newFixnum(((DERInteger)v0).getValue().intValue()));
        } else {
            this.set_version(this.getRuntime().newFixnum(2));
        }
        this.set_last_update(RubyTime.newTime(this.getRuntime(), this.crl.getThisUpdate().getTime()));
        this.set_next_update(RubyTime.newTime(this.getRuntime(), this.crl.getNextUpdate().getTime()));
        RubyString name2 = RubyString.newString(this.getRuntime(), this.crl.getIssuerX500Principal().getEncoded());
        this.set_issuer(Utils.newRubyInstance(this.getRuntime(), "OpenSSL::X509::Name", name2));
        this.revoked = this.getRuntime().newArray();
        DERSequence seqa = (DERSequence)((DERSequence)this.crl_v).getObjectAt(0);
        DERObject maybe_ext = (DERObject)seqa.getObjectAt(seqa.size() - 1);
        if (maybe_ext instanceof DERTaggedObject && ((DERTaggedObject)maybe_ext).getTagNo() == 0) {
            DERSequence exts = (DERSequence)((DERTaggedObject)maybe_ext).getObject();
            for (int i2 = 0; i2 < exts.size(); ++i2) {
                DERSequence seq2 = (DERSequence)exts.getObjectAt(i2);
                boolean critical2 = false;
                String oid2 = ((DERObjectIdentifier)seq2.getObjectAt(0)).getId();
                if (seq2.getObjectAt(1) == DERBoolean.TRUE) {
                    critical2 = true;
                }
                byte[] value2 = this.crl.getExtensionValue(oid2);
                RubyModule mASN1 = this.getRuntime().getClassFromPath("OpenSSL::ASN1");
                IRubyObject rValue = null;
                try {
                    rValue = ASN1.decode(mASN1, ASN1.decode(mASN1, RubyString.newString(this.getRuntime(), value2)).callMethod(this.getRuntime().getCurrentContext(), "value"));
                }
                catch (Exception e) {
                    rValue = RubyString.newString(this.getRuntime(), value2);
                }
                X509Extensions.Extension ext1 = (X509Extensions.Extension)Utils.newRubyInstance(this.getRuntime(), "OpenSSL::X509::Extension");
                ext1.setRealOid(ext1.getObjectIdentifier(oid2));
                ext1.setRealValue(rValue);
                ext1.setRealCritical(critical2);
                this.add_extension(ext1);
            }
        }
        this.changed = false;
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize_copy(IRubyObject obj) {
        System.err.println("WARNING: unimplemented method called: CRL#init_copy");
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        return this;
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        StringWriter w = new StringWriter();
        try {
            PEMInputOutput.writeX509CRL(w, this.crl);
            w.close();
            return this.getRuntime().newString(w.toString());
        }
        catch (IOException ioe) {
            throw X509CRL.newX509CRLError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return RubyString.newString(this.getRuntime(), this.crl_v.getEncoded());
        }
        catch (IOException ioe) {
            throw X509CRL.newX509CRLError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject to_text() {
        StringBuffer sbe = new StringBuffer();
        sbe.append("Certificate Revocation List (CRL):\n");
        sbe.append(IND8).append("Version ").append(RubyNumeric.fix2int(this.version) + 1).append(" (0x");
        sbe.append(Integer.toString(RubyNumeric.fix2int(this.version), 16)).append(")\n");
        sbe.append(IND8).append("Signature Algorithm: ").append(ASN1.nid2ln(this.getRuntime(), ASN1.obj2nid(this.getRuntime(), (DERObjectIdentifier)((DERSequence)((DERSequence)this.crl_v).getObjectAt(1)).getObjectAt(0)))).append("\n");
        sbe.append(IND8).append("Issuer: ").append(this.issuer()).append("\n");
        sbe.append(IND8).append("Last Update: ").append(ASN_DATE.format(((RubyTime)this.last_update()).getJavaDate())).append("\n");
        if (!this.next_update().isNil()) {
            sbe.append(IND8).append("Next Update: ").append(ASN_DATE.format(((RubyTime)this.next_update()).getJavaDate())).append("\n");
        } else {
            sbe.append(IND8).append("Next Update: NONE\n");
        }
        if (this.extensions.size() > 0) {
            sbe.append(IND8).append("CRL extensions\n");
            for (X509Extensions.Extension extension : this.extensions) {
                DERObjectIdentifier oiden = extension.getRealOid();
                sbe.append(IND12).append(ASN1.o2a(this.getRuntime(), oiden)).append(": ");
                if (extension.getRealCritical()) {
                    sbe.append("critical");
                }
                sbe.append("\n");
                sbe.append(IND16).append(extension.value()).append("\n");
            }
        }
        return this.getRuntime().newString(sbe.toString());
    }

    @JRubyMethod
    public IRubyObject version() {
        return this.version;
    }

    @JRubyMethod(name={"version="})
    public IRubyObject set_version(IRubyObject val) {
        if (!val.equals(this.version)) {
            this.changed = true;
        }
        this.version = val;
        return val;
    }

    @JRubyMethod
    public IRubyObject signature_algorithm() {
        return this.sig_alg;
    }

    @JRubyMethod
    public IRubyObject issuer() {
        return this.issuer;
    }

    @JRubyMethod(name={"issuer="})
    public IRubyObject set_issuer(IRubyObject val) {
        if (!val.equals(this.issuer)) {
            this.changed = true;
        }
        this.issuer = val;
        this.generator.setIssuerDN(((X509Name)this.issuer).getRealName());
        return val;
    }

    @JRubyMethod
    public IRubyObject last_update() {
        return this.last_update;
    }

    @JRubyMethod(name={"last_update="})
    public IRubyObject set_last_update(IRubyObject val) {
        this.changed = true;
        this.last_update = val.callMethod(this.getRuntime().getCurrentContext(), "getutc");
        ((RubyTime)this.last_update).setMicroseconds(0L);
        this.generator.setThisUpdate(((RubyTime)this.last_update).getJavaDate());
        this.last_update = val;
        return val;
    }

    @JRubyMethod
    public IRubyObject next_update() {
        return this.next_update;
    }

    @JRubyMethod(name={"next_update="})
    public IRubyObject set_next_update(IRubyObject val) {
        this.changed = true;
        this.next_update = val.callMethod(this.getRuntime().getCurrentContext(), "getutc");
        ((RubyTime)this.next_update).setMicroseconds(0L);
        this.generator.setNextUpdate(((RubyTime)this.next_update).getJavaDate());
        this.next_update = val;
        return val;
    }

    @JRubyMethod
    public IRubyObject revoked() {
        return this.revoked;
    }

    @JRubyMethod(name={"revoked="})
    public IRubyObject set_revoked(IRubyObject val) {
        this.changed = true;
        this.revoked = val;
        return val;
    }

    @JRubyMethod
    public IRubyObject add_revoked(IRubyObject val) {
        this.changed = true;
        this.revoked.callMethod(this.getRuntime().getCurrentContext(), "<<", val);
        return val;
    }

    @JRubyMethod
    public IRubyObject extensions() {
        return this.getRuntime().newArray(this.extensions);
    }

    @JRubyMethod(name={"extensions="})
    public IRubyObject set_extensions(IRubyObject val) {
        this.extensions = ((RubyArray)val).getList();
        return val;
    }

    @JRubyMethod
    public IRubyObject add_extension(IRubyObject val) {
        this.extensions.add(val);
        return val;
    }

    @JRubyMethod
    public IRubyObject sign(final IRubyObject key2, IRubyObject digest2) {
        String keyAlg = ((PKey)key2).getAlgorithm();
        String digAlg = ((Digest)digest2).getShortAlgorithm();
        if ("DSA".equalsIgnoreCase(keyAlg) && "MD5".equalsIgnoreCase(digAlg) || "RSA".equalsIgnoreCase(keyAlg) && "DSS1".equals(((Digest)digest2).name().toString()) || "DSA".equalsIgnoreCase(keyAlg) && "SHA1".equals(((Digest)digest2).name().toString())) {
            throw X509CRL.newX509CRLError(this.getRuntime(), null);
        }
        this.sig_alg = this.getRuntime().newString(digAlg);
        this.generator.setSignatureAlgorithm(digAlg + "WITH" + keyAlg);
        for (IRubyObject obj : ((RubyArray)this.revoked).toJavaArray()) {
            X509Revoked rev = (X509Revoked)obj;
            BigInteger serial2 = new BigInteger(rev.callMethod(this.getRuntime().getCurrentContext(), "serial").toString());
            IRubyObject t1 = rev.callMethod(this.getRuntime().getCurrentContext(), "time").callMethod(this.getRuntime().getCurrentContext(), "getutc");
            ((RubyTime)t1).setMicroseconds(0L);
            this.generator.addCRLEntry(serial2, ((RubyTime)t1).getJavaDate(), new X509Extensions(new Hashtable()));
        }
        try {
            for (X509Extensions.Extension extension : this.extensions) {
                this.generator.addExtension(extension.getRealOid(), extension.getRealCritical(), extension.getRealValueBytes());
            }
        }
        catch (IOException ioe) {
            throw X509CRL.newX509CRLError(this.getRuntime(), ioe.getMessage());
        }
        try {
            OpenSSLReal.doWithBCProvider(new OpenSSLReal.Runnable(){

                public void run() throws GeneralSecurityException {
                    X509CRL.this.crl = X509CRL.this.generator.generate(((PKey)key2).getPrivateKey(), "BC");
                }
            });
        }
        catch (GeneralSecurityException gse) {
            throw X509CRL.newX509CRLError(this.getRuntime(), gse.getMessage());
        }
        try {
            this.crl_v = new ASN1InputStream(new ByteArrayInputStream(this.crl.getEncoded())).readObject();
        }
        catch (CRLException crle) {
            throw X509CRL.newX509CRLError(this.getRuntime(), crle.getMessage());
        }
        catch (IOException ioe) {
            throw X509CRL.newX509CRLError(this.getRuntime(), ioe.getMessage());
        }
        DERSequence v1 = (DERSequence)((DERSequence)this.crl_v).getObjectAt(0);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        int copyIndex = 0;
        if (v1.getObjectAt(0) instanceof DERInteger) {
            ++copyIndex;
        }
        aSN1EncodableVector.add(new DERInteger(new BigInteger(this.version.toString())));
        while (copyIndex < v1.size()) {
            aSN1EncodableVector.add(v1.getObjectAt(copyIndex++));
        }
        ASN1EncodableVector build2 = new ASN1EncodableVector();
        build2.add(new DERSequence(aSN1EncodableVector));
        build2.add(((DERSequence)this.crl_v).getObjectAt(1));
        build2.add(((DERSequence)this.crl_v).getObjectAt(2));
        this.crl_v = new DERSequence(build2);
        this.changed = false;
        return this;
    }

    @JRubyMethod
    public IRubyObject verify(IRubyObject key2) {
        if (this.changed) {
            return this.getRuntime().getFalse();
        }
        try {
            this.crl.verify(((PKey)key2).getPublicKey());
            return this.getRuntime().getTrue();
        }
        catch (Exception ignored) {
            return this.getRuntime().getFalse();
        }
    }

    private static RaiseException newX509CRLError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::X509::CRLError", message2);
    }
}

