/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.DefinedMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Colon3Node
extends Node
implements INameNode {
    protected String name;
    private volatile transient IRubyObject cachedValue;
    private volatile Object generation;

    public Colon3Node(ISourcePosition position, String name2) {
        super(position);
        this.name = name2;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.COLON3NODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitColon3Node(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public RubyModule getEnclosingModule(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return runtime.getObject();
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject value2 = this.getValue(context);
        return value2 != null ? value2 : runtime.getObject().getConstantFromConstMissing(this.name);
    }

    @Override
    public RubyString definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            RubyClass left2 = runtime.getObject();
            if (this.hasConstant(left2)) {
                return runtime.getDefinedMessage(DefinedMessage.CONSTANT);
            }
            if (this.hasMethod(left2)) {
                return runtime.getDefinedMessage(DefinedMessage.METHOD);
            }
        }
        catch (JumpException excptn) {
            // empty catch block
        }
        return null;
    }

    private boolean hasConstant(RubyModule left2) {
        return left2.getConstantAt(this.name, false) != null;
    }

    private boolean hasMethod(IRubyObject left2) {
        return left2.getMetaClass().isMethodBound(this.name, true);
    }

    public IRubyObject getValue(ThreadContext context) {
        IRubyObject value2 = this.cachedValue;
        return this.isCached(context, value2) ? value2 : this.reCache(context, this.name);
    }

    private boolean isCached(ThreadContext context, IRubyObject value2) {
        return value2 != null && this.generation == context.runtime.getConstantInvalidator().getData();
    }

    public IRubyObject reCache(ThreadContext context, String name2) {
        IRubyObject value2;
        Ruby runtime = context.runtime;
        Object newGeneration = runtime.getConstantInvalidator().getData();
        this.cachedValue = value2 = runtime.getObject().getConstantFromNoConstMissing(name2, false);
        if (value2 != null) {
            this.generation = newGeneration;
        }
        return value2;
    }
}

