/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.defined;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.defined.DefinedInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalIsDefinedInstr
extends DefinedInstr {
    public GlobalIsDefinedInstr(Variable result2, StringLiteral name2) {
        super(Operation.GLOBAL_IS_DEFINED, result2, new Operand[]{name2});
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.operands[0] = this.operands[0].getSimplifiedOperand(valueMap, force);
    }

    public StringLiteral getName() {
        return (StringLiteral)this.operands[0];
    }

    @Override
    public Instr cloneForInlining(InlinerInfo inlinerInfo) {
        return new GlobalIsDefinedInstr((Variable)this.getResult().cloneForInlining(inlinerInfo), (StringLiteral)this.getOperands()[0].cloneForInlining(inlinerInfo));
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getName() + ")";
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        Ruby runtime = context.runtime;
        return runtime.newBoolean(runtime.getGlobalVariables().isDefined(this.getName().string));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.GlobalIsDefinedInstr(this);
    }
}

